/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wst.xsd.ui.internal.adt.design.DesignViewerGraphicConstants;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.StructureEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.ICompartmentFigure;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IStructureFigure;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures.StructureFigure;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.layouts.RowLayout;
import org.eclipse.wst.xsd.ui.internal.design.figures.GenericGroupFigure;

public class CompartmentFigure
extends Figure
implements ICompartmentFigure {
    public Label nodeNameLabel;
    protected Figure contentPane;
    protected Figure annotationArea;
    public Figure rowFigure = new Figure();

    public CompartmentFigure() {
        this.add((IFigure)this.rowFigure);
        this.annotationArea = new Figure(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void paint(Graphics graphics) {
                super.paint(graphics);
                try {
                    graphics.pushState();
                    graphics.setForegroundColor(ColorConstants.blue);
                    graphics.setFont(DesignViewerGraphicConstants.smallFont);
                    List children = this.getChildren();
                    Iterator i = children.iterator();
                    while (i.hasNext()) {
                        Figure object = (Figure)i.next();
                        this.traverse(object, graphics);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    graphics.popState();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                }
                graphics.popState();
            }

            private void traverse(Figure figure, Graphics graphics) {
                List children = figure.getChildren();
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    GenericGroupFigure fig;
                    Figure object = (Figure)i.next();
                    if (object instanceof GenericGroupFigure && (fig = (GenericGroupFigure)object).hasText()) {
                        graphics.drawText(fig.getText(), fig.getTextCoordinates());
                    }
                    this.traverse(object, graphics);
                }
            }
        };
        ToolbarLayout annotationLayout = new ToolbarLayout(false);
        annotationLayout.setStretchMinorAxis(true);
        this.annotationArea.setLayoutManager((LayoutManager)annotationLayout);
        this.rowFigure.add((IFigure)this.annotationArea);
        this.contentPane = new Figure(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.pushState();
                try {
                    boolean isFirst = true;
                    Color oldColor = graphics.getForegroundColor();
                    graphics.setForegroundColor(ColorConstants.lightGray);
                    Iterator i = this.getChildren().iterator();
                    while (true) {
                        block5: {
                            if (i.hasNext()) break block5;
                            graphics.setForegroundColor(oldColor);
                            break;
                        }
                        Figure figure = (Figure)i.next();
                        Rectangle r = figure.getBounds();
                        if (isFirst) {
                            isFirst = false;
                            continue;
                        }
                        graphics.setForegroundColor(ColorConstants.white);
                        graphics.setBackgroundColor(ColorConstants.lightGray);
                        graphics.fillGradient(r.x, r.y, r.width, 1, false);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    graphics.popState();
                    throw throwable;
                }
                {
                    Object var7_9 = null;
                }
                graphics.popState();
            }
        };
        this.contentPane.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.rowFigure.add((IFigure)this.contentPane);
        RowLayout rowLayout = new RowLayout();
        this.rowFigure.setLayoutManager((LayoutManager)rowLayout);
        rowLayout.setConstraint((IFigure)this.annotationArea, "annotation");
        rowLayout.setConstraint((IFigure)this.contentPane, "contentPane");
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    public IFigure getAnnotationPane() {
        return this.annotationArea;
    }

    public void editPartAttached(EditPart owner) {
        StructureEditPart structureEditPart = null;
        EditPart parent = owner.getParent();
        while (parent != null) {
            if (parent instanceof StructureEditPart) {
                structureEditPart = (StructureEditPart)parent;
                break;
            }
            parent = parent.getParent();
        }
        RowLayout rowLayout = (RowLayout)this.rowFigure.getLayoutManager();
        IStructureFigure typeFigure = structureEditPart.getStructureFigure();
        Assert.isTrue((boolean)(typeFigure instanceof StructureFigure), (String)"Expected object of type StructureFigure");
        rowLayout.setColumnData(((StructureFigure)typeFigure).getColumnData());
    }

    public void addSelectionFeedback() {
    }

    public void removeSelectionFeedback() {
    }

    public void refreshVisuals(Object model) {
    }
}

