/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.helper.CliCompileProcessResult;
import org.eclipse.n4js.cli.helper.CliCompileResult;
import org.eclipse.n4js.cli.helper.GeneratedJSFilesCounter;
import org.eclipse.n4js.cli.helper.InProcessExecuter;
import org.eclipse.n4js.cli.helper.ProcessResult;
import org.eclipse.n4js.cli.helper.TestProcessExecuter;

public class CliTools {
    public static final long DEFAULT_TIMEOUT_IN_MINUTES = 30L;
    private static final String RELATIVE_PATH = "...";
    private final Map<String, String> environment = new HashMap<String, String>();
    private boolean inheritIO = false;
    private boolean ignoreFailure = false;
    private long timeout = 30L;
    private TimeUnit timeoutUnit = TimeUnit.MINUTES;

    public void callN4jscFrontendInprocess(String[] options, boolean removeUsage, CliCompileResult result) {
        InProcessExecuter inProcessExecuter = new InProcessExecuter(false, this.inheritIO);
        inProcessExecuter.n4jsc(new File("").getAbsoluteFile(), options, result);
        CliTools.trimOutputs(result, removeUsage);
        CliTools.checkForFailure("n4jsc (front-end only, in process)", result, this.ignoreFailure);
    }

    public void callN4jscInprocess(N4jscOptions options, boolean removeUsage, CliCompileResult result) {
        String[] args = (String[])options.toArgs().toArray(String[]::new);
        InProcessExecuter inProcessExecuter = new InProcessExecuter(true, this.inheritIO);
        inProcessExecuter.n4jsc((File)options.getDirs().get(0), args, result);
        CliTools.trimOutputs(result, removeUsage);
        CliTools.checkForFailure("n4jsc (with backend, in process)", result, this.ignoreFailure);
    }

    public void callN4jscExprocess(N4jscOptions options, boolean removeUsage, CliCompileProcessResult cliResult) {
        List srcFiles = options.getDirs();
        File fileArg = srcFiles.isEmpty() ? new File("").getAbsoluteFile() : (File)srcFiles.get(0);
        ProcessResult n4jscResult = this.getExProcessExecuter().n4jscRun(fileArg.toPath(), this.environment, options);
        cliResult.workingDir = n4jscResult.getWorkingDir();
        cliResult.command = n4jscResult.getCommand();
        cliResult.exception = n4jscResult.getException();
        cliResult.exitCode = n4jscResult.getExitCode();
        cliResult.stdOut = n4jscResult.getStdOut();
        cliResult.errOut = n4jscResult.getErrOut();
        cliResult.transpiledFiles = GeneratedJSFilesCounter.getTranspiledFiles(fileArg.toPath());
        CliTools.trimOutputs(cliResult, removeUsage);
        CliTools.checkForFailure("n4jsc (ex process)", cliResult, this.ignoreFailure);
    }

    public void setEnvironmentVariable(String name, String value) {
        this.environment.put(name, value);
    }

    public void setInheritIO(boolean inheritIO) {
        this.inheritIO = inheritIO;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public void setTimeout(long duration, TimeUnit unit) {
        this.timeout = duration;
        this.timeoutUnit = unit;
    }

    public ProcessResult runNodejs(Path workingDir, Path runFile, String ... options) {
        return this.getExProcessExecuter().runNodejs(workingDir, this.environment, runFile, options);
    }

    public ProcessResult npmInstall(Path workingDir, String ... options) {
        String[] installOptions = (String[])Lists.asList((Object)"install", (Object[])options).toArray(String[]::new);
        return this.runNpm(workingDir, installOptions);
    }

    public ProcessResult npmList(Path workingDir, String ... options) {
        String[] listOptions = (String[])Lists.asList((Object)"list", (Object[])options).toArray(String[]::new);
        return this.runNpm(workingDir, listOptions);
    }

    public ProcessResult runNpm(Path workingDir, String ... options) {
        return this.getExProcessExecuter().npmRun(workingDir, this.environment, options);
    }

    public ProcessResult yarnInstall(Path workingDir, String ... options) {
        String[] installOptions = (String[])Lists.asList((Object)"install", (Object[])options).toArray(String[]::new);
        return this.runYarn(workingDir, installOptions);
    }

    public ProcessResult runYarn(Path workingDir, String ... options) {
        return this.getExProcessExecuter().yarnRun(workingDir, this.environment, options);
    }

    public ProcessResult run(Path workingDir, Path executable, String ... options) {
        return this.getExProcessExecuter().run(workingDir, this.environment, executable, options);
    }

    private TestProcessExecuter getExProcessExecuter() {
        Injector injector = N4jscFactory.getOrCreateInjector();
        TestProcessExecuter tpExecuter = new TestProcessExecuter(injector, this.inheritIO, this.ignoreFailure, this.timeout, this.timeoutUnit);
        return tpExecuter;
    }

    static void trimOutputs(ProcessResult result, boolean removeUsage) {
        String workingDirAbsolute = new File(result.getWorkingDir()).getAbsolutePath();
        result.stdOut = result.stdOut.replace(workingDirAbsolute, RELATIVE_PATH);
        result.errOut = result.errOut.replace(workingDirAbsolute, RELATIVE_PATH);
        if (removeUsage) {
            result.stdOut = result.stdOut.replace("Usage: n4jsc [GOAL] DIR [OPTION(s)]", "");
            result.errOut = result.errOut.replace("Usage: n4jsc [GOAL] DIR [OPTION(s)]", "");
        }
        result.stdOut = result.stdOut.trim();
        result.errOut = result.errOut.trim();
    }

    static void checkForFailure(String executableName, ProcessResult result, boolean ignoreFailure) {
        CliCompileResult compileResult;
        if (ignoreFailure) {
            return;
        }
        if (result.getException() != null) {
            throw new CliException("exception during " + executableName + System.lineSeparator() + result, result, result.getException());
        }
        if (result.getExitCode() != 0) {
            throw new CliException("non-zero exit code from " + executableName + ": " + result.getExitCode() + System.lineSeparator() + result, result);
        }
        if (result instanceof CliCompileResult && !(result instanceof CliCompileProcessResult) && (compileResult = (CliCompileResult)result).getErrs() > 0) {
            throw new CliException("errors in compiled sources: " + Joiner.on((String)System.lineSeparator()).join(compileResult.getErrMsgs()) + System.lineSeparator() + result, result);
        }
    }

    public static class CliException
    extends RuntimeException {
        private final ProcessResult result;

        public CliException(String message, ProcessResult result) {
            this(message, result, null);
        }

        public CliException(String message, ProcessResult result, Throwable cause) {
            super(message, cause);
            this.result = result;
        }

        public ProcessResult getResult() {
            return this.result;
        }
    }
}

