/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.ui.quickfix;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.validation.Issue;

public abstract class DelegatingQuickfixProvider
extends DefaultQuickfixProvider {
    public boolean hasResolutionFor(String issueCode) {
        if (super.hasResolutionFor(issueCode)) {
            return true;
        }
        return Iterables.any(this.getDelegates(), p -> p.hasResolutionFor(issueCode));
    }

    public List<IssueResolution> getResolutions(Issue issue) {
        List resolutions = super.getResolutions(issue);
        resolutions.addAll(FluentIterable.from(this.getDelegates()).transformAndConcat(p -> p.getResolutions(issue)).toList());
        return resolutions;
    }

    protected abstract Iterable<? extends IssueResolutionProvider> getDelegates();
}

