/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.CatchVariable;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.ModifierUtils;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class N4JSSyntaxValidator
extends AbstractN4JSDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    private boolean checkModifiers(ModifiableElement elem) {
        return this.holdsNoInvalidOrDuplicateModifiers(elem) && this.holdsNotMoreThanOneAccessModifier(elem) && this.holdsCorrectOrder(elem);
    }

    private boolean holdsNoInvalidOrDuplicateModifiers(ModifiableElement elem) {
        boolean hasIssue = false;
        HashSet<N4Modifier> checked = new HashSet<N4Modifier>();
        int idx = 0;
        while (idx < elem.getDeclaredModifiers().size()) {
            ILeafNode node;
            boolean duplicate;
            N4Modifier mod = (N4Modifier)elem.getDeclaredModifiers().get(idx);
            boolean bl = duplicate = !checked.add(mod);
            if (!ModifierUtils.isValid((EClass)elem.eClass(), (N4Modifier)mod)) {
                node = ModifierUtils.getNodeForModifier((ModifiableElement)elem, (int)idx);
                this.addIssue(IssueCodes.getMessageForSYN_MODIFIER_INVALID(mod.getName(), this.keywordProvider.keyword(elem)), (EObject)elem, node.getOffset(), node.getLength(), "SYN_MODIFIER_INVALID");
                hasIssue = true;
            } else if (duplicate) {
                node = ModifierUtils.getNodeForModifier((ModifiableElement)elem, (int)idx);
                this.addIssue(IssueCodes.getMessageForSYN_MODIFIER_DUPLICATE(mod.getName()), (EObject)elem, node.getOffset(), node.getLength(), "SYN_MODIFIER_DUPLICATE");
                hasIssue = true;
            }
            ++idx;
        }
        return !hasIssue;
    }

    private boolean holdsNotMoreThanOneAccessModifier(ModifiableElement elem) {
        boolean hasIssue = false;
        boolean hasAccessModifier = false;
        int idx = 0;
        while (idx < elem.getDeclaredModifiers().size()) {
            N4Modifier mod = (N4Modifier)elem.getDeclaredModifiers().get(idx);
            boolean isAccessModifier = ModifierUtils.isAccessModifier((N4Modifier)mod);
            if (hasAccessModifier && isAccessModifier) {
                ILeafNode node = ModifierUtils.getNodeForModifier((ModifiableElement)elem, (int)idx);
                this.addIssue(IssueCodes.getMessageForSYN_MODIFIER_ACCESS_SEVERAL(), (EObject)elem, node.getOffset(), node.getLength(), "SYN_MODIFIER_ACCESS_SEVERAL");
                hasIssue = true;
            }
            hasAccessModifier |= isAccessModifier;
            ++idx;
        }
        return !hasIssue;
    }

    private boolean holdsCorrectOrder(ModifiableElement elem) {
        boolean isOrderMessedUp = false;
        int lastValue = -1;
        for (N4Modifier mod : elem.getDeclaredModifiers()) {
            int currValue = mod.getValue();
            if (currValue < lastValue) {
                isOrderMessedUp = true;
                break;
            }
            lastValue = currValue;
        }
        if (isOrderMessedUp) {
            List modifiers = ModifierUtils.getSortedModifiers((Collection)elem.getDeclaredModifiers());
            String modifiersStr = Joiner.on((char)' ').join(modifiers.iterator());
            ILeafNode nodeFirst = ModifierUtils.getNodeForModifier((ModifiableElement)elem, (int)0);
            ILeafNode nodeLast = ModifierUtils.getNodeForModifier((ModifiableElement)elem, (int)(elem.getDeclaredModifiers().size() - 1));
            this.addIssue(IssueCodes.getMessageForSYN_MODIFIER_BAD_ORDER(modifiersStr), (EObject)elem, nodeFirst.getOffset(), nodeLast.getOffset() - nodeFirst.getOffset() + nodeLast.getLength(), "SYN_MODIFIER_BAD_ORDER");
            return false;
        }
        return true;
    }

    @Check
    public void checkClassDefinition(N4ClassDefinition n4ClassDefinition) {
        this.holdsCorrectOrderOfExtendsImplements(n4ClassDefinition);
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)n4ClassDefinition);
        ILeafNode keywordNode = this.findSecondLeafWithKeyword((EObject)n4ClassDefinition, "{", node, "extends", false);
        if (keywordNode != null) {
            TClass tclass = n4ClassDefinition.getDefinedTypeAsClass();
            if (tclass == null) {
                return;
            }
            if (StreamSupport.stream(tclass.getImplementedInterfaceRefs().spliterator(), false).allMatch(superTypeRef -> superTypeRef.getDeclaredType() instanceof TInterface)) {
                List interfaces = StreamSupport.stream(tclass.getImplementedInterfaceRefs().spliterator(), false).map(ref -> (TInterface)ref.getDeclaredType()).collect(Collectors.toList());
                String message = IssueCodes.getMessageForSYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP(this.validatorMessageHelper.description((EObject)tclass), "extend", "interface" + (interfaces.size() > 1 ? "s " : " ") + this.validatorMessageHelper.names(interfaces), "implements");
                this.addIssue(message, (EObject)n4ClassDefinition, keywordNode.getTotalOffset(), keywordNode.getLength(), "SYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP");
            }
        }
    }

    @Check
    public void checkInterfaceDeclaration(N4InterfaceDeclaration n4InterfaceDecl) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)n4InterfaceDecl);
        ILeafNode keywordNode = this.findLeafWithKeyword((EObject)n4InterfaceDecl, "{", node, "implements", false);
        if (keywordNode != null) {
            TInterface tinterface = n4InterfaceDecl.getDefinedTypeAsInterface();
            if (tinterface == null) {
                return;
            }
            if (tinterface.getSuperInterfaceRefs().isEmpty()) {
                return;
            }
            if (tinterface.getSuperInterfaceRefs().stream().allMatch(superTypeRef -> superTypeRef.getDeclaredType() instanceof TInterface)) {
                List interfaces = tinterface.getSuperInterfaceRefs().stream().flatMap(ref -> {
                    Type declaredType = ref.getDeclaredType();
                    if (declaredType instanceof TInterface) {
                        return Stream.of((TInterface)declaredType);
                    }
                    return Stream.empty();
                }).collect(Collectors.toList());
                String message = IssueCodes.getMessageForSYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP(this.validatorMessageHelper.description((EObject)tinterface), "implement", "interface" + (interfaces.size() > 1 ? "s " : " ") + this.validatorMessageHelper.names(interfaces), "extends");
                this.addIssue(message, (EObject)n4InterfaceDecl, keywordNode.getTotalOffset(), keywordNode.getLength(), "SYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP");
            }
        }
    }

    private boolean holdsCorrectOrderOfExtendsImplements(N4ClassDefinition semanticElement) {
        int implementsOffset;
        if (semanticElement.getSuperClassRef() == null || semanticElement.getImplementedInterfaceRefs().isEmpty()) {
            return true;
        }
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)semanticElement);
        if (node == null) {
            return true;
        }
        ILeafNode extendsNode = this.findLeafWithKeyword((EObject)semanticElement, "{", node, "extends", false);
        ILeafNode implementsNode = this.findLeafWithKeyword((EObject)semanticElement, "{", node, "implements", false);
        if (extendsNode == null || implementsNode == null) {
            return true;
        }
        int extendsOffset = extendsNode.getOffset();
        if (extendsOffset > (implementsOffset = implementsNode.getOffset())) {
            String message = IssueCodes.getMessageForSYN_KW_EXTENDS_IMPLEMENTS_WRONG_ORDER();
            this.addIssue(message, (EObject)semanticElement, extendsOffset, "extends".length(), "SYN_KW_EXTENDS_IMPLEMENTS_WRONG_ORDER");
            return false;
        }
        return true;
    }

    private ILeafNode findLeafWithKeyword(EObject semanticElement, String stopAtKeyword, ICompositeNode node, String keyWord, boolean commaAlternative) {
        return this.doFindLeafWithKeyword(semanticElement, stopAtKeyword, node, keyWord, commaAlternative, 1);
    }

    private ILeafNode findSecondLeafWithKeyword(EObject semanticElement, String stopAtKeyword, ICompositeNode node, String keyWord, boolean commaAlternative) {
        return this.doFindLeafWithKeyword(semanticElement, stopAtKeyword, node, keyWord, commaAlternative, 2);
    }

    private ILeafNode doFindLeafWithKeyword(EObject semanticElement, String stopAtKeyword, ICompositeNode node, String keyWord, boolean commaAlternative, int hitNumber) {
        int foundHits = 0;
        BidiTreeIterator iter = node.getAsTreeIterable().iterator();
        while (iter.hasNext()) {
            ILeafNode leaf;
            EObject grammarElement;
            INode child = (INode)iter.next();
            EObject childSemElement = child.getSemanticElement();
            if (child != node && childSemElement != null && childSemElement != semanticElement) {
                iter.prune();
                continue;
            }
            if (!(child instanceof ILeafNode) || !((grammarElement = (leaf = (ILeafNode)child).getGrammarElement()) instanceof Keyword)) continue;
            String value = ((Keyword)grammarElement).getValue();
            if (stopAtKeyword.equals(value)) {
                return null;
            }
            if (!keyWord.equals(value)) continue;
            if (grammarElement.eContainer() instanceof Alternatives) {
                boolean inCommaAlternative;
                AbstractElement first = (AbstractElement)((Alternatives)grammarElement.eContainer()).getElements().get(0);
                boolean bl = inCommaAlternative = first instanceof Keyword && ",".equals(((Keyword)first).getValue());
                if (inCommaAlternative != commaAlternative || ++foundHits < hitNumber) continue;
                return leaf;
            }
            if (commaAlternative || ++foundHits < hitNumber) continue;
            return leaf;
        }
        return null;
    }

    @Check
    public void checkCatchVariable(CatchVariable catchVariable) {
        if (catchVariable.getDeclaredTypeRef() != null) {
            this.addIssue(IssueCodes.getMessageForAST_CATCH_VAR_TYPED(), (EObject)catchVariable, (EStructuralFeature)N4JSPackage.eINSTANCE.getTypedElement_DeclaredTypeRef(), "AST_CATCH_VAR_TYPED", new String[0]);
        }
    }
}

