/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.accessModifiers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.scoping.accessModifiers.InvisibleCtorDescription;
import org.eclipse.n4js.scoping.accessModifiers.MemberVisibilityChecker;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.xtext.scoping.FilterWithErrorMarkerScope;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class VisibilityAwareCtorScope
extends FilterWithErrorMarkerScope {
    private final NewExpression context;
    private final ContainerTypesHelper containerTypesHelper;
    private final MemberVisibilityChecker checker;

    public VisibilityAwareCtorScope(IScope parent, MemberVisibilityChecker checker, ContainerTypesHelper containerTypesHelper, NewExpression context) {
        super(parent);
        this.checker = checker;
        this.context = context;
        this.containerTypesHelper = containerTypesHelper;
    }

    protected IEObjectDescriptionWithError wrapFilteredDescription(IEObjectDescription originalDescr) {
        EObject proxyOrInstance = originalDescr.getEObjectOrProxy();
        TClassifier ctorClassifier = (TClassifier)proxyOrInstance;
        return new InvisibleCtorDescription(originalDescr, (Type)ctorClassifier);
    }

    protected boolean isAccepted(IEObjectDescription description) {
        EObject proxyOrInstance = description.getEObjectOrProxy();
        if (proxyOrInstance != null && !proxyOrInstance.eIsProxy() && proxyOrInstance instanceof TClassifier) {
            TClassifier ctorClassifier = (TClassifier)proxyOrInstance;
            if (ctorClassifier.isAbstract()) {
                return true;
            }
            TMethod usedCtor = this.containerTypesHelper.fromContext((EObject)this.context).findConstructor((ContainerType<?>)ctorClassifier);
            if (usedCtor != null && usedCtor.isConstructor()) {
                return this.checker.isConstructorVisible(this.context, (TypeRef)TypeUtils.createTypeRef((Type)ctorClassifier, (TypeArgument[])new TypeArgument[0]), usedCtor);
            }
        }
        return true;
    }
}

