/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.util.Strings;

public final class ValueConverterUtils {
    public static String convertToEscapedString(String sourceStr, boolean useUnicode) {
        int len = sourceStr.length();
        StringBuilder result = new StringBuilder(len + 20);
        int off = 0;
        while (off < len) {
            char ch = sourceStr.charAt(off++);
            ValueConverterUtils.escapeAndAppendTo(ch, useUnicode, result);
        }
        return result.toString();
    }

    private static void escapeAndAppendTo(char c, boolean useUnicode, StringBuilder result) {
        String appendMe;
        switch (c) {
            case '\b': {
                appendMe = "\\b";
                break;
            }
            case '\t': {
                appendMe = "\\t";
                break;
            }
            case '\n': {
                appendMe = "\\n";
                break;
            }
            case '\f': {
                appendMe = "\\f";
                break;
            }
            case '\r': {
                appendMe = "\\r";
                break;
            }
            case '\"': {
                appendMe = "\\\"";
                break;
            }
            case '\'': {
                appendMe = "\\'";
                break;
            }
            case '\\': {
                appendMe = "\\\\";
                break;
            }
            case '\u000b': {
                appendMe = "\\v";
                break;
            }
            case '\u0000': {
                appendMe = "\\0";
                break;
            }
            default: {
                if (useUnicode && ValueConverterUtils.mustEncodeAsEscapeSequence(c)) {
                    result.append("\\u");
                    int i = 12;
                    while (i >= 0) {
                        result.append(Strings.toHex((int)(c >> i & 0xF)));
                        i -= 4;
                    }
                } else {
                    result.append(c);
                }
                return;
            }
        }
        result.append(appendMe);
    }

    private static boolean mustEncodeAsEscapeSequence(char next) {
        return next < ' ' || next > '~';
    }

    public static StringConverterResult convertFromEscapedString(String sourceStr, boolean allowStringEscSeq, boolean keepBackSlashForUnknownEscSeq, boolean errorForUnknownEscSeq, CharacterValidityChecker validityChecker) {
        int len = sourceStr.length();
        StringConverterResult result = new StringConverterResult(validityChecker, len);
        int off = 0;
        while (off < len) {
            char ch;
            if ((ch = sourceStr.charAt(off++)) == '\\') {
                if (off < len) {
                    off = ValueConverterUtils.unescape(sourceStr, off, allowStringEscSeq, keepBackSlashForUnknownEscSeq, errorForUnknownEscSeq, result);
                    continue;
                }
                result.errorAt(off);
                if (!keepBackSlashForUnknownEscSeq) continue;
                result.append('\\', off);
                continue;
            }
            if (ch == '\r') {
                result.append('\n', off);
                if (off >= len || sourceStr.charAt(off) != '\n') continue;
                ++off;
                continue;
            }
            result.append(ch, off);
        }
        result.seal();
        return result;
    }

    private static int unescape(String str, int off, boolean allowStringEscSeq, boolean keepBackSlashForUnknownEscSeq, boolean errorForUnknownEscSeq, StringConverterResult result) {
        char ch = str.charAt(off);
        int offNew = ch == 'u' || allowStringEscSeq && ch == 'x' ? ValueConverterUtils.unescapeUnicodeSequence(str, off, result) : (allowStringEscSeq && ch >= '0' && ch <= '9' ? ValueConverterUtils.unescapeOctalSequence(str, off, result) : (allowStringEscSeq ? ValueConverterUtils.unescapeSimpleControlChar(str, off, result) : off));
        if (offNew == off) {
            ++offNew;
            if (errorForUnknownEscSeq) {
                result.errorAt(off);
            }
            if (keepBackSlashForUnknownEscSeq) {
                result.append('\\', off);
            }
            result.append(ch, off);
        }
        return offNew;
    }

    private static int unescapeUnicodeSequence(String str, int off, StringConverterResult result) {
        int codePoint;
        int offNext;
        int end;
        int len = str.length();
        boolean modeU = str.charAt(off) != 'x';
        int start = off + 1;
        if (modeU && start < len && str.charAt(start) == '{') {
            if ((end = str.indexOf(125, ++start)) - start <= 0) {
                result.errorAt(off);
                return off;
            }
            offNext = end + 1;
        } else {
            offNext = end = start + (modeU ? 4 : 2);
        }
        try {
            codePoint = Integer.parseInt(str.substring(start, end), 16);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            result.errorAt(off);
            return off;
        }
        if (!Character.isValidCodePoint(codePoint)) {
            result.errorAt(off);
            return off;
        }
        result.appendCodePoint(codePoint, off);
        return offNext;
    }

    private static int unescapeOctalSequence(String str, int off, StringConverterResult result) {
        int codePoint;
        int len = str.length();
        int maxDigits = 2;
        char firstChar = str.charAt(off);
        if (firstChar != '0') {
            result.warningAt(off);
            if (firstChar >= '8' && firstChar <= '9') {
                return off;
            }
        }
        if (firstChar >= '0' && firstChar <= '3') {
            ++maxDigits;
        }
        int start = off;
        int end = off + 1;
        while (end < len && end - start < maxDigits && ValueConverterUtils.isOctalDigit(str.charAt(end))) {
            ++end;
        }
        try {
            codePoint = Integer.parseInt(str.substring(start, end), 8);
        }
        catch (NumberFormatException e) {
            result.errorAt(off);
            return off;
        }
        if (!Character.isValidCodePoint(codePoint)) {
            result.errorAt(off);
            return off;
        }
        result.appendCodePoint(codePoint, off);
        return end;
    }

    private static boolean isOctalDigit(char ch) {
        return ch >= '0' && ch <= '7';
    }

    private static int unescapeSimpleControlChar(String str, int off, StringConverterResult result) {
        char ch = str.charAt(off++);
        switch (ch) {
            case 't': {
                result.append('\t', off);
                return off;
            }
            case 'r': {
                result.append('\r', off);
                return off;
            }
            case 'n': {
                result.append('\n', off);
                return off;
            }
            case 'f': {
                result.append('\f', off);
                return off;
            }
            case 'b': {
                result.append('\b', off);
                return off;
            }
            case 'v': {
                result.append('\u000b', off);
                return off;
            }
            case '\"': {
                result.append('\"', off);
                return off;
            }
            case '\'': {
                result.append('\'', off);
                return off;
            }
            case '\r': {
                if (off < str.length() && str.charAt(off) == '\n') {
                    ++off;
                }
                return off;
            }
            case '\n': 
            case '\u2028': 
            case '\u2029': {
                return off;
            }
        }
        return off - 1;
    }

    private ValueConverterUtils() {
    }

    @FunctionalInterface
    public static interface CharacterValidityChecker {
        public boolean isValid(char var1, int var2);
    }

    public static class StringConverterResult {
        private CharacterValidityChecker validityChecker;
        private StringBuilder builder;
        private final List<IntPair> offsetMapping;
        private String value = null;
        private int invalidCharOff = -1;
        private int warningOff = -1;
        private int errorOff = -1;
        private int delta = 0;

        private StringConverterResult(CharacterValidityChecker validityChecker, int capacity) {
            this.validityChecker = validityChecker;
            this.builder = new StringBuilder(capacity);
            this.offsetMapping = new ArrayList<IntPair>();
        }

        public String getValue() {
            return this.value;
        }

        public boolean hasInvalidChar() {
            return this.invalidCharOff >= 0;
        }

        public boolean hasWarning() {
            return this.warningOff >= 0;
        }

        public boolean hasError() {
            return this.errorOff >= 0;
        }

        public int getInvalidCharOffset() {
            return this.invalidCharOff;
        }

        public int getWarningOffset() {
            return this.warningOff;
        }

        public int getErrorOffset() {
            return this.errorOff;
        }

        public int getSourceOffset(int targetOffset) {
            int i = this.offsetMapping.size() - 1;
            while (i >= 0) {
                IntPair mapping = this.offsetMapping.get(i);
                if (mapping.targetOffset <= targetOffset) {
                    return mapping.sourceOffset + targetOffset - mapping.targetOffset;
                }
                --i;
            }
            return targetOffset;
        }

        private void append(char ch, int srcOffset) {
            this.maintainMapping(srcOffset - 1);
            if (this.validityChecker == null || this.validityChecker.isValid(ch, this.builder.length())) {
                this.builder.append(ch);
            } else {
                this.invalidCharAt(srcOffset);
            }
        }

        private void appendCodePoint(int codePoint, int srcOffset) {
            this.maintainMapping(srcOffset - 1);
            if (this.validityChecker == null || Character.isBmpCodePoint(codePoint) && this.validityChecker.isValid((char)codePoint, this.builder.length())) {
                this.builder.appendCodePoint(codePoint);
            } else {
                this.invalidCharAt(srcOffset);
            }
        }

        private void maintainMapping(int srcOffset) {
            if (srcOffset + this.delta != this.builder.length()) {
                this.offsetMapping.add(new IntPair(srcOffset, this.builder.length()));
                this.delta = this.builder.length() - srcOffset;
            }
        }

        private void seal() {
            this.value = this.builder.toString();
            this.builder = null;
            this.validityChecker = null;
        }

        private void invalidCharAt(int offset) {
            if (this.invalidCharOff < 0) {
                this.invalidCharOff = offset;
            }
        }

        private void warningAt(int offset) {
            if (this.warningOff < 0) {
                this.warningOff = offset;
            }
        }

        private void errorAt(int offset) {
            if (this.errorOff < 0) {
                this.errorOff = offset;
            }
        }

        static class IntPair {
            final int sourceOffset;
            final int targetOffset;

            IntPair(int sourceOffset, int targetOffset) {
                this.sourceOffset = sourceOffset;
                this.targetOffset = targetOffset;
            }

            public String toString() {
                return String.valueOf(this.sourceOffset) + "->" + this.targetOffset;
            }
        }
    }
}

