/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal.lsp;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.xtext.util.IAcceptor;

public interface FileVisitingAcceptor
extends FileVisitor<Path>,
IAcceptor<URI> {
    public void accept(URI var1);

    @Override
    default public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    default public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        this.accept(new FileURI(file.toFile()).toURI());
        return FileVisitResult.CONTINUE;
    }

    @Override
    default public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        throw exc;
    }

    @Override
    default public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (exc != null) {
            throw exc;
        }
        return FileVisitResult.CONTINUE;
    }
}

