/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.findReferences;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.findReferences.SimpleResourceAccess;
import org.eclipse.n4js.ts.findReferences.TargetURIKey;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IResourceDescription;

@Singleton
public class ConcreteSyntaxAwareReferenceFinder
extends ReferenceFinder {
    @Inject
    private TargetURIKey keys;
    @Inject
    private LazyURIEncoder uriEncoder;
    @Inject
    private LinkingHelper linkingHelper;

    protected void findReferencesInDescription(TargetURIs targetURIs, IResourceDescription resourceDescription, IReferenceFinder.IResourceAccess resourceAccess, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        TargetURIKey.Data findReferencesData = this.keys.getData(targetURIs, resourceAccess);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Set typesOrModulesToFind = findReferencesData.getTypesOrModulesToFind();
        if (typesOrModulesToFind.isEmpty()) {
            return;
        }
        Iterable importedNames = resourceDescription.getImportedNames();
        if (importedNames instanceof List) {
            List sorted;
            List searchMe = sorted = (List)importedNames;
            for (QualifiedName typeOrModuleToFind : typesOrModulesToFind) {
                int insertionIndex = Collections.binarySearch(searchMe, typeOrModuleToFind);
                if (insertionIndex >= 0) {
                    resourceAccess.readOnly(resourceDescription.getURI(), resourceSet -> {
                        this.findReferences((Predicate<URI>)targetURIs, resourceSet.getResource(resourceDescription.getURI(), true), acceptor, monitor);
                        return null;
                    });
                    return;
                }
                int startFrom = -(insertionIndex + 1);
                if (startFrom >= sorted.size()) {
                    return;
                }
                searchMe = sorted.subList(startFrom, sorted.size());
            }
        } else {
            for (QualifiedName importedName : importedNames) {
                if (!typesOrModulesToFind.contains(importedName)) continue;
                resourceAccess.readOnly(resourceDescription.getURI(), resourceSet -> {
                    this.findReferences((Predicate<URI>)targetURIs, resourceSet.getResource(resourceDescription.getURI(), true), acceptor, monitor);
                    return null;
                });
                return;
            }
        }
    }

    public void findReferences(Predicate<URI> targetURIs, Resource resource, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        EList astContents;
        this.keys.getData((TargetURIs)targetURIs, (IReferenceFinder.IResourceAccess)new SimpleResourceAccess(resource.getResourceSet()));
        if (resource instanceof N4JSResource) {
            Script script = (Script)((N4JSResource)resource).getContents().get(0);
            astContents = new BasicEList();
            astContents.add((Object)script);
        } else {
            astContents = resource.getContents();
        }
        for (EObject content : astContents) {
            this.findReferences(targetURIs, content, acceptor, monitor);
        }
    }

    protected boolean doProcess(EReference reference, Predicate<URI> targetURISet) {
        return ((TargetURIKey.Data)((TargetURIs)targetURISet).getUserData(TargetURIKey.KEY)).isEReferenceTypeApplicable(reference.getEReferenceType());
    }

    protected EObject toValidInstanceOrNull(Resource resource, Predicate<URI> targetURIs, EObject value) {
        EObject result;
        block6: {
            result = value;
            if (result.eIsProxy()) {
                URI proxyURI = EcoreUtil.getURI((EObject)result);
                if (this.uriEncoder.isCrossLinkFragment(resource, proxyURI.fragment())) {
                    INode node = (INode)this.uriEncoder.decode(resource, proxyURI.fragment()).getThird();
                    try {
                        String string = this.linkingHelper.getCrossRefNodeAsString(node, true);
                        if (((TargetURIKey.Data)((TargetURIs)targetURIs).getUserData(TargetURIKey.KEY)).isMatchingConcreteSyntax(string)) {
                            result = this.resolveInternalProxy(value, resource);
                            break block6;
                        }
                        result = null;
                    }
                    catch (IllegalNodeException ine) {
                        result = null;
                    }
                } else {
                    result = this.resolveInternalProxy(value, resource);
                }
            }
        }
        return result;
    }

    protected void findLocalReferencesFromElement(Predicate<URI> targetURIs, EObject sourceCandidate, Resource localResource, IReferenceFinder.Acceptor acceptor) {
        URI sourceURI = null;
        if (this.doProcess(sourceCandidate, targetURIs)) {
            for (EReference ref : sourceCandidate.eClass().getEAllReferences()) {
                int i;
                Object value = sourceCandidate.eGet((EStructuralFeature)ref, false);
                if (!sourceCandidate.eIsSet((EStructuralFeature)ref) || value == null) continue;
                if (ref.isContainment()) {
                    if (ref.isMany()) {
                        InternalEList contentList = (InternalEList)value;
                        i = 0;
                        while (i < contentList.size()) {
                            EObject childElement = (EObject)contentList.basicGet(i);
                            if (!childElement.eIsProxy()) {
                                this.findLocalReferencesFromElement(targetURIs, childElement, localResource, acceptor);
                            }
                            ++i;
                        }
                        continue;
                    }
                    EObject childElement = (EObject)value;
                    if (childElement.eIsProxy()) continue;
                    this.findLocalReferencesFromElement(targetURIs, childElement, localResource, acceptor);
                    continue;
                }
                if (ref.isContainer() || ref == N4JSPackage.Literals.SCRIPT__MODULE || ref == N4JSPackage.Literals.TYPE_DEFINING_ELEMENT__DEFINED_TYPE || ref == N4JSPackage.Literals.N4_FIELD_DECLARATION__DEFINED_FIELD || ref == N4JSPackage.Literals.GETTER_DECLARATION__DEFINED_GETTER || ref == N4JSPackage.Literals.SETTER_DECLARATION__DEFINED_SETTER || ref == N4JSPackage.Literals.N4_ENUM_LITERAL__DEFINED_LITERAL || ref == N4JSPackage.Literals.EXPORTED_VARIABLE_DECLARATION__DEFINED_VARIABLE || ref == TypesPackage.Literals.TSTRUCT_MEMBER__DEFINED_MEMBER || !this.doProcess(ref, targetURIs)) continue;
                if (ref.isMany()) {
                    InternalEList values = (InternalEList)value;
                    i = 0;
                    while (i < values.size()) {
                        this.checkValue((EObject)values.basicGet(i), localResource, targetURIs, sourceCandidate, sourceURI, ref, acceptor);
                        ++i;
                    }
                    continue;
                }
                this.checkValue((EObject)value, localResource, targetURIs, sourceCandidate, sourceURI, ref, acceptor);
            }
        }
    }

    private void checkValue(EObject value, Resource localResource, Predicate<URI> targetURIs, EObject sourceCandidate, URI sourceURI, EReference ref, IReferenceFinder.Acceptor acceptor) {
        URI refURI;
        EObject instanceOrProxy = this.toValidInstanceOrNull(localResource, targetURIs, value);
        if (instanceOrProxy != null && this.referenceHasBeenFound(targetURIs, refURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)instanceOrProxy), instanceOrProxy)) {
            sourceURI = sourceURI == null ? EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)sourceCandidate) : sourceURI;
            acceptor.accept(sourceCandidate, sourceURI, ref, -1, instanceOrProxy, refURI);
        }
    }

    private boolean referenceHasBeenFound(Predicate<URI> targetURIs, URI refURI, EObject instanceOrProxy) {
        boolean result = false;
        if (instanceOrProxy instanceof TMember && ((TMember)instanceOrProxy).isComposed()) {
            TMember member = (TMember)instanceOrProxy;
            if (member.isComposed()) {
                for (TMember constituentMember : member.getConstituentMembers()) {
                    URI constituentReffURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)constituentMember);
                    boolean bl = result = result || targetURIs.apply((Object)constituentReffURI);
                }
            }
        } else {
            result = targetURIs.apply((Object)refURI);
        }
        return result;
    }
}

