/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.DelegationAssistant;
import org.eclipse.n4js.transpiler.im.DelegatingMember;
import org.eclipse.n4js.transpiler.utils.ConcreteMembersOrderedForTranspiler;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.util.AccessorTuple;
import org.eclipse.n4js.utils.Log;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Log
public class MemberPatchingTransformation
extends Transformation {
    @Inject
    private DelegationAssistant delegationAssistant;
    @Inject
    private TypeAssistant typeAssistant;
    private static final Logger logger = Logger.getLogger(MemberPatchingTransformation.class);

    public void assertPreConditions() {
        this.typeAssistant.assertClassifierPreConditions();
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<N4ClassifierDeclaration> _function = it -> this.transformClassifierDecl((EObject)it);
        this.collectNodes((EObject)this.getState().im, N4ClassifierDeclaration.class, false).forEach(_function);
    }

    private void _transformClassifierDecl(N4InterfaceDeclaration ifcDecl) {
        TInterface tIfc = this.getState().info.getOriginalDefinedType(ifcDecl);
        ConcreteMembersOrderedForTranspiler cmoft = this.typeAssistant.getOrCreateCMOFT((TClassifier)tIfc);
        for (TMember m : cmoft.ownedAndMixedInConcreteMembers) {
            boolean isInherited;
            if (m instanceof TField) continue;
            ContainerType _containingType = m.getContainingType();
            boolean bl = isInherited = _containingType != tIfc;
            if (!isInherited) continue;
            DelegatingMember delegator = this.delegationAssistant.createDelegatingMember((TClassifier)tIfc, m);
            this.getState().info.markAsConsumedFromInterface((N4MemberDeclaration)delegator);
            EList _ownedMembersRaw = ifcDecl.getOwnedMembersRaw();
            _ownedMembersRaw.add((Object)delegator);
        }
    }

    private void _transformClassifierDecl(N4ClassDeclaration classDecl) {
        EList _ownedMembersRaw;
        DelegatingMember member;
        TClass tClass = this.getState().info.getOriginalDefinedType(classDecl);
        ConcreteMembersOrderedForTranspiler cmoft = this.typeAssistant.getOrCreateCMOFT((TClassifier)tClass);
        Functions.Function1 _function = m -> {
            EObject _eContainer = m.eContainer();
            return _eContainer != tClass;
        };
        List consumedMethods = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)cmoft.ownedAndMixedInConcreteMembers, TMethod.class), (Functions.Function1)_function));
        for (TMethod m2 : consumedMethods) {
            member = this.delegationAssistant.createDelegatingMember((TClassifier)tClass, (TMember)m2);
            this.getState().info.markAsConsumedFromInterface((N4MemberDeclaration)member);
            _ownedMembersRaw = classDecl.getOwnedMembersRaw();
            _ownedMembersRaw.add((Object)member);
        }
        for (AccessorTuple accTuple : cmoft.concreteAccessorTuples) {
            if (accTuple.getGetter() != null && accTuple.getGetter().getContainingType() != tClass && accTuple.getInheritedGetter() == null) {
                TGetter g = accTuple.getGetter();
                DelegatingMember member2 = this.delegationAssistant.createDelegatingMember((TClassifier)tClass, (TMember)g);
                this.getState().info.markAsConsumedFromInterface((N4MemberDeclaration)member2);
                EList _ownedMembersRaw2 = classDecl.getOwnedMembersRaw();
                _ownedMembersRaw2.add((Object)member2);
            }
            if (accTuple.getSetter() == null || accTuple.getSetter().getContainingType() == tClass || accTuple.getInheritedSetter() != null) continue;
            TSetter s = accTuple.getSetter();
            DelegatingMember member_1 = this.delegationAssistant.createDelegatingMember((TClassifier)tClass, (TMember)s);
            this.getState().info.markAsConsumedFromInterface((N4MemberDeclaration)member_1);
            EList _ownedMembersRaw_1 = classDecl.getOwnedMembersRaw();
            _ownedMembersRaw_1.add((Object)member_1);
        }
        for (TField field : cmoft.fieldsPurelyMixedInNotOverridingAccessor) {
            member = TranspilerBuilderBlocks._N4MemberDecl((TMember)field, (Statement[])new Statement[0]);
            _ownedMembersRaw = classDecl.getOwnedMembersRaw();
            _ownedMembersRaw.add((Object)member);
            this.getState().info.setOriginalDefinedMember((N4MemberDeclaration)member, (TMember)field);
            this.getState().info.markAsConsumedFromInterface((N4MemberDeclaration)member);
        }
        for (AccessorTuple accTuple_1 : cmoft.concreteAccessorTuples) {
            if (accTuple_1.getInheritedGetter() != null && accTuple_1.getGetter() == null && accTuple_1.getSetter() != null) {
                String _name = accTuple_1.getSetter().getName();
                String _plus = "Encountered an invalid getter shadowing. Setter " + _name;
                String _plus_1 = String.valueOf(_plus) + " of classifier ";
                ContainerType _containingType = accTuple_1.getSetter().getContainingType();
                String _plus_2 = String.valueOf(_plus_1) + _containingType;
                String _plus_3 = String.valueOf(_plus_2);
                IllegalStateException _illegalStateException = new IllegalStateException("Invalid shadowing of inherited getter. Getter should be implemented explicitly.");
                logger.error((Object)_plus_3, (Throwable)_illegalStateException);
            }
            if (accTuple_1.getInheritedSetter() == null || accTuple_1.getGetter() == null || accTuple_1.getSetter() != null) continue;
            String _name_1 = accTuple_1.getGetter().getName();
            String _plus_4 = "Encountered an invalid inherited setter shadowing. Getter " + _name_1;
            String _plus_5 = String.valueOf(_plus_4) + " of classifier ";
            ContainerType _containingType_1 = accTuple_1.getGetter().getContainingType();
            String _plus_6 = String.valueOf(_plus_5) + _containingType_1;
            String _plus_7 = String.valueOf(_plus_6);
            IllegalStateException _illegalStateException_1 = new IllegalStateException("Invalid shadowing of inherited setter. Setter should be implemented explicitly.");
            logger.error((Object)_plus_7, (Throwable)_illegalStateException_1);
        }
    }

    private void transformClassifierDecl(EObject classDecl) {
        if (classDecl instanceof N4ClassDeclaration) {
            this._transformClassifierDecl((N4ClassDeclaration)classDecl);
            return;
        }
        if (classDecl instanceof N4InterfaceDeclaration) {
            this._transformClassifierDecl((N4InterfaceDeclaration)classDecl);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(classDecl).toString());
    }
}

