/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow.guards;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardAssertion;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;

public class Guard {
    public final Expression condition;
    public final GuardType type;
    public final GuardAssertion asserts;
    public final ControlFlowElement symbolCFE;
    private Symbol symbol;

    public Guard(Expression condition, GuardType type, GuardAssertion asserts, ControlFlowElement symbolCFE) {
        this.condition = condition;
        this.type = type;
        this.asserts = asserts;
        this.symbolCFE = symbolCFE;
    }

    final void initSymbol(SymbolFactory symbolFactory) {
        this.symbol = this.getSymbol(symbolFactory);
        if (this.symbol != null && !this.symbol.isVariableSymbol()) {
            this.symbol = null;
        }
    }

    protected Symbol getSymbol(SymbolFactory symbolFactory) {
        return symbolFactory.create(this.symbolCFE);
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Guard)) {
            return false;
        }
        Guard guard = (Guard)obj;
        boolean equals = true;
        equals &= this.condition == guard.condition;
        equals &= this.type == guard.type;
        equals &= this.asserts == guard.asserts;
        return equals &= this.symbolCFE == guard.symbolCFE;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.condition, this.type, this.asserts, this.symbolCFE});
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + this.type.toString();
        str = String.valueOf(str) + " " + this.asserts.toString();
        str = String.valueOf(str) + " on " + FGUtils.getSourceText((EObject)this.symbolCFE);
        return str;
    }
}

