/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.model;

import java.util.Objects;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.n4JS.LabelledStatement;

public class JumpToken
implements Comparable<JumpToken> {
    public final ControlFlowType cfType;
    public final LabelledStatement lblStmt;
    private final int cachedHash;

    public JumpToken(ControlFlowType type) {
        this(type, null);
    }

    public JumpToken(ControlFlowType type, LabelledStatement lblStmt) {
        this.cfType = type;
        this.lblStmt = lblStmt;
        this.cachedHash = Objects.hash(new Object[]{this.cfType, lblStmt});
    }

    @Override
    public int compareTo(JumpToken jumpToken) {
        int result = this.cfType.compareTo(jumpToken.cfType);
        if (result == 0) {
            if (this.lblStmt != null && jumpToken.lblStmt != null) {
                return this.lblStmt.hashCode() - jumpToken.lblStmt.hashCode();
            }
            if (this.lblStmt != null) {
                return -1;
            }
            if (jumpToken.lblStmt != null) {
                return 1;
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JumpToken)) {
            return false;
        }
        JumpToken jt = (JumpToken)o;
        boolean equals = true;
        equals &= this.cfType == jt.cfType;
        return equals &= this.lblStmt == jt.lblStmt;
    }

    public int hashCode() {
        return this.cachedHash;
    }

    public String toString() {
        String s = this.cfType.name();
        if (this.lblStmt != null) {
            s = String.valueOf(s) + " " + this.lblStmt;
        }
        return s;
    }
}

