/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MatchSection
extends PDESection
implements IPartSelectionListener {
    private Button fReexportButton;
    private Button fOptionalButton;
    private FormEntry fVersionText;
    private ComboPart fMatchCombo;
    protected IPluginReference fCurrentImport;
    private boolean fBlockChanges = false;
    private boolean fAddReexport = true;

    public MatchSection(PDEFormPage formPage, Composite parent, boolean addReexport) {
        super(formPage, parent, 128);
        this.fAddReexport = addReexport;
        this.createClient(this.getSection(), formPage.getEditor().getToolkit());
    }

    public void commit(boolean onSave) {
        if (!this.isDirty()) {
            return;
        }
        if (this.fCurrentImport != null && this.fVersionText.getText().isEnabled()) {
            this.fVersionText.commit();
            String value = this.fVersionText.getValue();
            int match = 0;
            if (value != null && value.length() > 0) {
                this.applyVersion(value);
                match = this.getMatch();
            }
            this.applyMatch(match);
        }
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fVersionText.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        if (this.fAddReexport) {
            this.createOptionalButton(toolkit, container);
            this.createReexportButton(toolkit, container);
        }
        this.fVersionText = new FormEntry(container, toolkit, PDEUIMessages.ManifestEditor_MatchSection_version, null, false);
        this.fVersionText.setFormEntryListener(new FormEntryAdapter(this, this.getPage().getEditor().getEditorSite().getActionBars()){

            @Override
            public void textValueChanged(FormEntry text) {
                MatchSection.this.applyVersion(text.getValue());
            }

            @Override
            public void textDirty(FormEntry text) {
                if (MatchSection.this.fBlockChanges) {
                    return;
                }
                MatchSection.this.markDirty();
                MatchSection.this.fBlockChanges = true;
                MatchSection.this.resetMatchCombo(MatchSection.this.fCurrentImport);
                MatchSection.this.fBlockChanges = false;
            }
        });
        Label matchLabel = toolkit.createLabel(container, PDEUIMessages.ManifestEditor_PluginSpecSection_versionMatch);
        matchLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fMatchCombo = new ComboPart();
        this.fMatchCombo.createControl(container, toolkit, 8);
        this.fMatchCombo.add("");
        this.fMatchCombo.add(PDEUIMessages.ManifestEditor_MatchSection_equivalent);
        this.fMatchCombo.add(PDEUIMessages.ManifestEditor_MatchSection_compatible);
        this.fMatchCombo.add(PDEUIMessages.ManifestEditor_MatchSection_perfect);
        this.fMatchCombo.add(PDEUIMessages.ManifestEditor_MatchSection_greater);
        this.fMatchCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fMatchCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.fBlockChanges) {
                this.applyMatch(this.fMatchCombo.getSelectionIndex());
            }
        }));
        toolkit.paintBordersFor(container);
        this.initialize();
        this.update(null);
        section.setClient((Control)container);
        section.setText(PDEUIMessages.MatchSection_title);
        section.setDescription(PDEUIMessages.MatchSection_desc);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(770));
    }

    private void createReexportButton(FormToolkit toolkit, Composite container) {
        this.fReexportButton = toolkit.createButton(container, PDEUIMessages.ManifestEditor_MatchSection_reexport, 32);
        this.fReexportButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.fBlockChanges && this.fCurrentImport instanceof IPluginImport) {
                try {
                    IPluginImport iimport = (IPluginImport)this.fCurrentImport;
                    iimport.setReexported(this.fReexportButton.getSelection());
                }
                catch (CoreException ex) {
                    PDEPlugin.logException(ex);
                }
            }
        }));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fReexportButton.setLayoutData((Object)gd);
    }

    private void createOptionalButton(FormToolkit toolkit, Composite container) {
        this.fOptionalButton = toolkit.createButton(container, PDEUIMessages.ManifestEditor_MatchSection_optional, 32);
        this.fOptionalButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.fBlockChanges) {
                return;
            }
            if (!this.fBlockChanges && this.fCurrentImport instanceof IPluginImport) {
                try {
                    IPluginImport iimport = (IPluginImport)this.fCurrentImport;
                    iimport.setOptional(this.fOptionalButton.getSelection());
                }
                catch (CoreException ex) {
                    PDEPlugin.logException(ex);
                }
            }
        }));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fOptionalButton.setLayoutData((Object)gd);
    }

    private void applyVersion(String version) {
        try {
            if (this.fCurrentImport != null) {
                this.fCurrentImport.setVersion(version);
            }
        }
        catch (CoreException ex) {
            PDEPlugin.logException(ex);
        }
    }

    private void applyMatch(int match) {
        try {
            if (this.fCurrentImport != null) {
                this.fCurrentImport.setMatch(match);
            }
        }
        catch (CoreException ex) {
            PDEPlugin.logException(ex);
        }
    }

    private int getMatch() {
        return this.fMatchCombo.getSelectionIndex();
    }

    public void dispose() {
        IModel model = (IModel)this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void initialize() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        Object object;
        if (e.getChangeType() == 2) {
            Object obj = e.getChangedObjects()[0];
            if (obj.equals(this.fCurrentImport)) {
                this.update(null);
            }
        } else if (e.getChangeType() == 3 && (object = e.getChangedObjects()[0]).equals(this.fCurrentImport)) {
            this.update(this.fCurrentImport);
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() == 1) {
            Object changeObject = ((IStructuredSelection)selection).getFirstElement();
            IPluginImport input = null;
            if (changeObject instanceof ImportObject) {
                input = ((ImportObject)changeObject).getImport();
            } else if (changeObject instanceof IPluginReference) {
                input = (IPluginReference)changeObject;
            }
            this.update((IPluginReference)input);
        } else {
            this.update(null);
        }
    }

    private void resetMatchCombo(IPluginReference iimport) {
        this.fMatchCombo.getControl().setEnabled(this.isEditable() && this.fVersionText.getText().getText().length() > 0);
        this.setMatchCombo(iimport);
    }

    private void setMatchCombo(IPluginReference iimport) {
        this.fMatchCombo.select(iimport != null ? iimport.getMatch() : 0);
    }

    protected void update(IPluginReference iimport) {
        this.fBlockChanges = true;
        if (iimport == null) {
            if (this.fAddReexport) {
                this.fOptionalButton.setSelection(false);
                this.fOptionalButton.setEnabled(false);
                this.fReexportButton.setSelection(false);
                this.fReexportButton.setEnabled(false);
            }
            this.fVersionText.setValue(null, true);
            this.fVersionText.setEditable(false);
            this.fMatchCombo.getControl().setEnabled(false);
            this.fMatchCombo.setText("");
            this.fCurrentImport = null;
            this.fBlockChanges = false;
            return;
        }
        if (this.fCurrentImport != null && !iimport.equals(this.fCurrentImport) && this.isEditable()) {
            this.commit(false);
        }
        this.fCurrentImport = iimport;
        if (this.fCurrentImport instanceof IPluginImport) {
            IPluginImport pimport = (IPluginImport)this.fCurrentImport;
            this.fOptionalButton.setEnabled(this.isEditable());
            this.fOptionalButton.setSelection(pimport.isOptional());
            this.fReexportButton.setEnabled(this.isEditable());
            this.fReexportButton.setSelection(pimport.isReexported());
        }
        this.fVersionText.setEditable(this.isEditable());
        this.fVersionText.setValue(this.fCurrentImport.getVersion());
        this.resetMatchCombo(this.fCurrentImport);
        this.fBlockChanges = false;
    }
}

