/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;

public class SCCUtils {
    public static <T> List<List<T>> findSCCs(Iterator<T> verticesToCheck, Function<T, Iterable<T>> fnNext) {
        return new SCCAnalyzer<T>(fnNext).findSCCs(verticesToCheck);
    }

    private static final class SCCAnalyzer<T> {
        final Function<T, Iterable<T>> fnNext;
        int i = 0;
        final Map<T, SCCData> data = new HashMap<T, SCCData>();
        final Stack<T> stack_of_points = new Stack();
        final List<List<T>> result = new LinkedList<List<T>>();

        public SCCAnalyzer(Function<T, Iterable<T>> fnNext) {
            this.fnNext = fnNext;
        }

        private void STRONGCONNECT(T v) {
            SCCData wData;
            ++this.i;
            SCCData vData = new SCCData();
            this.data.put(v, vData);
            vData.LOWLINK = this.i;
            vData.NUMBER = this.i;
            this.stack_of_points.push(v);
            vData.onStack = true;
            for (T w : this.fnNext.apply(v)) {
                wData = this.data.get(w);
                if (wData == null || wData.NUMBER < 0) {
                    this.STRONGCONNECT(w);
                    wData = this.data.get(w);
                    vData.LOWLINK = Math.min(vData.LOWLINK, wData.LOWLINK);
                    continue;
                }
                if (wData.NUMBER >= vData.NUMBER || !wData.onStack) continue;
                vData.LOWLINK = Math.min(vData.LOWLINK, wData.NUMBER);
            }
            if (vData.LOWLINK == vData.NUMBER) {
                LinkedList<Object> scc = new LinkedList<Object>();
                Object w = !this.stack_of_points.isEmpty() ? this.stack_of_points.peek() : null;
                wData = w != null ? this.data.get(w) : null;
                while (wData != null && wData.NUMBER >= vData.NUMBER) {
                    wData.onStack = false;
                    this.stack_of_points.pop();
                    scc.add(w);
                    w = !this.stack_of_points.isEmpty() ? this.stack_of_points.peek() : null;
                    SCCData sCCData = wData = w != null ? this.data.get(w) : null;
                }
                this.result.add(scc);
            }
        }

        private List<List<T>> findSCCs(Iterator<T> vertices) {
            this.i = 0;
            this.data.clear();
            this.stack_of_points.clear();
            this.result.clear();
            while (vertices.hasNext()) {
                T w = vertices.next();
                SCCData wData = this.data.get(w);
                if (wData != null && wData.NUMBER >= 0) continue;
                this.STRONGCONNECT(w);
            }
            return this.result;
        }

        private static class SCCData {
            int LOWLINK = -1;
            int NUMBER = -1;
            boolean onStack = false;

            private SCCData() {
            }
        }
    }
}

