/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.ui.external.ComputeProjectOrder;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;

public class BuildOrderComputer {
    @Inject
    private IN4JSCore core;
    private final UriToProjectMapper uri2PrjMapper = new UriToProjectMapper();

    public ComputeProjectOrder.VertexOrder<IN4JSProject> getBuildOrder(N4JSExternalProject[] projects) {
        IN4JSProject[] n4jsPrjs = new IN4JSProject[projects.length];
        int i = 0;
        while (i < projects.length) {
            N4JSExternalProject project = projects[i];
            IN4JSProject lookupResult = this.uri2PrjMapper.get(project.getIProject().getLocation());
            n4jsPrjs[i] = lookupResult != null ? lookupResult : project.getIProject();
            ++i;
        }
        return this.getBuildOrder(n4jsPrjs);
    }

    public ComputeProjectOrder.VertexOrder<IN4JSProject> getBuildOrder(IN4JSProject[] requestedProjects) {
        SafeURI[] requestedProjectURIs = new SafeURI[requestedProjects.length];
        int i = 0;
        while (i < requestedProjectURIs.length) {
            requestedProjectURIs[i] = requestedProjects[i].getLocation();
            ++i;
        }
        ComputeProjectOrder.VertexOrder<SafeURI<?>> completeOrder = this.getBuildOrderOfURIs(requestedProjectURIs);
        ComputeProjectOrder.VertexOrder<IN4JSProject> requestedOrder = ComputeProjectOrder.mapVertexOrder(completeOrder, this.uri2PrjMapper);
        return requestedOrder;
    }

    private ComputeProjectOrder.VertexOrder<SafeURI<?>> getBuildOrderOfURIs(SafeURI<?>[] requestedProjectURIs) {
        FilterUnrequestedOut filter = new FilterUnrequestedOut(requestedProjectURIs);
        ComputeProjectOrder.VertexOrder<SafeURI<?>> completeOrder = this.computeVertexOrder(requestedProjectURIs);
        ComputeProjectOrder.VertexOrder<SafeURI<?>> requestedOrder = ComputeProjectOrder.filterVertexOrder(completeOrder, filter);
        return requestedOrder;
    }

    private ComputeProjectOrder.VertexOrder<SafeURI<?>> computeVertexOrder(SafeURI<?>[] requestedProjectURIs) {
        TreeSet<SafeURI> worklist = new TreeSet<SafeURI>(Comparator.comparing(Object::toString));
        SafeURI<?>[] safeURIArray = requestedProjectURIs;
        int n = requestedProjectURIs.length;
        int n2 = 0;
        while (n2 < n) {
            SafeURI<?> projectURI = safeURIArray[n2];
            IN4JSProject project = this.uri2PrjMapper.get(projectURI);
            if (project != null && project.exists()) {
                worklist.add(projectURI);
            }
            ++n2;
        }
        HashMultimap edges = HashMultimap.create();
        TreeSet<SafeURI> projectsClosure = new TreeSet<SafeURI>(Comparator.comparing(Object::toString));
        while (!worklist.isEmpty()) {
            SafeURI projectURI = worklist.pollFirst();
            projectsClosure.add(projectURI);
            IN4JSProject project = this.uri2PrjMapper.get(projectURI);
            Set<IN4JSProject> prjDependencies = this.getDependencies(project);
            HashSet<SafeURI> prjDependencyURIs = new HashSet<SafeURI>();
            for (IN4JSProject prjDependency : prjDependencies) {
                SafeURI depURI = prjDependency.getLocation();
                edges.put((Object)projectURI, (Object)depURI);
                prjDependencyURIs.add(depURI);
            }
            prjDependencyURIs.removeAll(projectsClosure);
            worklist.addAll(prjDependencyURIs);
        }
        ArrayList<SafeURI[]> edges2 = new ArrayList<SafeURI[]>();
        for (Map.Entry dependency : edges.entries()) {
            SafeURI prj = (SafeURI)dependency.getKey();
            SafeURI depOn = (SafeURI)dependency.getValue();
            edges2.add(new SafeURI[]{prj, depOn});
        }
        ComputeProjectOrder.VertexOrder<SafeURI<?>> orderedObjects = ComputeProjectOrder.computeVertexOrder(projectsClosure, edges2);
        return orderedObjects;
    }

    private Set<IN4JSProject> getDependencies(IN4JSProject project) {
        HashSet<IN4JSProject> prjDependencies = new HashSet<IN4JSProject>();
        ImmutableList deps = project.getAllDirectDependencies();
        for (IN4JSProject dep : deps) {
            IN4JSProject pDep = (IN4JSProject)this.core.findProject(dep.getLocation().toURI()).orNull();
            boolean isValidDep = true;
            isValidDep &= pDep != null && pDep.exists();
            if (!(isValidDep &= !(pDep instanceof N4JSEclipseProject) || ((N4JSEclipseProject)pDep).getProject().isOpen())) continue;
            prjDependencies.add(pDep);
        }
        return prjDependencies;
    }

    private static class FilterUnrequestedOut
    implements ComputeProjectOrder.VertexFilter<SafeURI<?>> {
        private final Set<SafeURI<?>> requestedProjectNames;

        FilterUnrequestedOut(SafeURI<?>[] requestedProjectNames) {
            this.requestedProjectNames = new HashSet(Arrays.asList(requestedProjectNames));
        }

        @Override
        public boolean matches(SafeURI<?> vertex) {
            boolean filterOut = !this.requestedProjectNames.contains(vertex);
            return filterOut;
        }
    }

    private class UriToProjectMapper
    implements ComputeProjectOrder.VertexMapper<SafeURI<?>, IN4JSProject> {
        private UriToProjectMapper() {
        }

        @Override
        public IN4JSProject get(SafeURI<?> projectURI) {
            IN4JSProject project = (IN4JSProject)BuildOrderComputer.this.core.findProject(projectURI.toURI()).orNull();
            return project;
        }

        @Override
        public Class<IN4JSProject> getTargetClass() {
            return IN4JSProject.class;
        }
    }
}

