/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.search.internal.core.text.TextSearchEngineRegistry;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SearchPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.search.preferences.SearchPreferencePage";
    public static final String IGNORE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.ignore";
    public static final String EMPHASIZE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.emphasize";
    public static final String POTENTIAL_MATCH_FG_COLOR = "org.eclipse.search.potentialMatch.fgColor";
    public static final String REUSE_EDITOR = "org.eclipse.search.reuseEditor";
    public static final String DEFAULT_PERSPECTIVE = "org.eclipse.search.defaultPerspective";
    private static final String NO_DEFAULT_PERSPECTIVE = "org.eclipse.search.defaultPerspective.none";
    public static final String BRING_VIEW_TO_FRONT = "org.eclipse.search.bringToFront";
    public static final String TEXT_SEARCH_ENGINE = "org.eclipse.search.textSearchEngine";
    public static final String TEXT_SEARCH_QUERY_PROVIDER = "org.eclipse.search.textSearchQueryProvider";
    public static final String LIMIT_HISTORY = "org.eclipse.search.limitHistory";
    private ColorFieldEditor fColorEditor;
    private BooleanFieldEditor fEmphasizedCheckbox;
    private BooleanFieldEditor fIgnorePotentialMatchesCheckbox;

    public SearchPreferencePage() {
        super(1);
        this.setPreferenceStore(SearchPlugin.getDefault().getPreferenceStore());
    }

    public static void initDefaults(IPreferenceStore store) {
        RGB gray = new RGB(85, 85, 85);
        store.setDefault(EMPHASIZE_POTENTIAL_MATCHES, true);
        store.setDefault(IGNORE_POTENTIAL_MATCHES, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)POTENTIAL_MATCH_FG_COLOR, (RGB)gray);
        store.setDefault(REUSE_EDITOR, true);
        store.setDefault(BRING_VIEW_TO_FRONT, true);
        store.setDefault(DEFAULT_PERSPECTIVE, NO_DEFAULT_PERSPECTIVE);
        store.setDefault(TEXT_SEARCH_ENGINE, "");
        store.setDefault(TEXT_SEARCH_QUERY_PROVIDER, "");
        store.setDefault(LIMIT_HISTORY, 10);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.search.search_preference_page_context");
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor(REUSE_EDITOR, SearchMessages.SearchPreferencePage_reuseEditor, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(BRING_VIEW_TO_FRONT, SearchMessages.SearchPreferencePage_bringToFront, this.getFieldEditorParent()));
        this.fIgnorePotentialMatchesCheckbox = new BooleanFieldEditor(IGNORE_POTENTIAL_MATCHES, SearchMessages.SearchPreferencePage_ignorePotentialMatches, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fIgnorePotentialMatchesCheckbox);
        this.fEmphasizedCheckbox = new BooleanFieldEditor(EMPHASIZE_POTENTIAL_MATCHES, SearchMessages.SearchPreferencePage_emphasizePotentialMatches, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fEmphasizedCheckbox);
        this.fColorEditor = new ColorFieldEditor(POTENTIAL_MATCH_FG_COLOR, SearchMessages.SearchPreferencePage_potentialMatchFgColor, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fColorEditor);
        this.fEmphasizedCheckbox.setEnabled(!SearchPreferencePage.arePotentialMatchesIgnored(), this.getFieldEditorParent());
        this.fColorEditor.setEnabled(!SearchPreferencePage.arePotentialMatchesIgnored() && SearchPreferencePage.arePotentialMatchesEmphasized(), this.getFieldEditorParent());
        SearchPreferencePage.handleDeletedPerspectives();
        String[][] perspectiveNamesAndIds = this.getPerspectiveNamesAndIds();
        ComboFieldEditor comboEditor = new ComboFieldEditor(DEFAULT_PERSPECTIVE, SearchMessages.SearchPreferencePage_defaultPerspective, perspectiveNamesAndIds, this.getFieldEditorParent());
        this.addField((FieldEditor)comboEditor);
        TextSearchEngineRegistry reg = SearchPlugin.getDefault().getTextSearchEngineRegistry();
        String[][] engineNamesAndIds = reg.getAvailableEngines();
        if (engineNamesAndIds.length > 1) {
            comboEditor = new ComboFieldEditor(TEXT_SEARCH_ENGINE, SearchMessages.SearchPreferencePage_textSearchEngine, engineNamesAndIds, this.getFieldEditorParent());
            this.addField((FieldEditor)comboEditor);
        }
    }

    public void setVisible(boolean state) {
        SearchPreferencePage.handleDeletedPerspectives();
        super.setVisible(state);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateFieldEnablement();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateFieldEnablement();
    }

    private void updateFieldEnablement() {
        boolean arePotentialMatchesIgnored = this.fIgnorePotentialMatchesCheckbox.getBooleanValue();
        this.fEmphasizedCheckbox.setEnabled(!arePotentialMatchesIgnored, this.getFieldEditorParent());
        this.fColorEditor.setEnabled(!arePotentialMatchesIgnored && this.fEmphasizedCheckbox.getBooleanValue(), this.getFieldEditorParent());
    }

    private String[][] getPerspectiveNamesAndIds() {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] perspectiveDescriptors = registry.getPerspectives();
        Arrays.sort(perspectiveDescriptors, new PerspectiveDescriptorComparator());
        String[][] table = new String[perspectiveDescriptors.length + 1][2];
        table[0][0] = SearchMessages.SearchPreferencePage_defaultPerspective_none;
        table[0][1] = NO_DEFAULT_PERSPECTIVE;
        int i = 0;
        while (i < perspectiveDescriptors.length) {
            table[i + 1][0] = perspectiveDescriptors[i].getLabel();
            table[i + 1][1] = perspectiveDescriptors[i].getId();
            ++i;
        }
        return table;
    }

    private static void handleDeletedPerspectives() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        String id = store.getString(DEFAULT_PERSPECTIVE);
        if (PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id) == null) {
            store.putValue(DEFAULT_PERSPECTIVE, NO_DEFAULT_PERSPECTIVE);
        }
    }

    public static String getDefaultPerspectiveId() {
        SearchPreferencePage.handleDeletedPerspectives();
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        String id = store.getString(DEFAULT_PERSPECTIVE);
        if (id == null || id.isEmpty() || id.equals(NO_DEFAULT_PERSPECTIVE)) {
            return null;
        }
        if (PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id) == null) {
            store.putValue(DEFAULT_PERSPECTIVE, id);
            return null;
        }
        return id;
    }

    public static boolean isEditorReused() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(REUSE_EDITOR);
    }

    public static boolean isViewBroughtToFront() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(BRING_VIEW_TO_FRONT);
    }

    public static boolean arePotentialMatchesIgnored() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(IGNORE_POTENTIAL_MATCHES);
    }

    public static boolean arePotentialMatchesEmphasized() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(EMPHASIZE_POTENTIAL_MATCHES);
    }

    public static RGB getPotentialMatchForegroundColor() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return PreferenceConverter.getColor((IPreferenceStore)store, (String)POTENTIAL_MATCH_FG_COLOR);
    }

    public static int getHistoryLimit() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        int limit = store.getInt(LIMIT_HISTORY);
        if (limit < 1) {
            limit = 1;
        } else if (limit >= 100) {
            limit = 99;
        }
        return limit;
    }

    private static class PerspectiveDescriptorComparator
    implements Comparator<IPerspectiveDescriptor> {
        private PerspectiveDescriptorComparator() {
        }

        @Override
        public int compare(IPerspectiveDescriptor o1, IPerspectiveDescriptor o2) {
            String id1 = o1.getLabel();
            String id2 = o2.getLabel();
            return Collator.getInstance().compare(id1, id2);
        }
    }
}

