/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.labeling.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class N4JSDecoratorRow
extends CompositeImageDescriptor {
    private final ImageDescriptor main;
    private final int quadrant;
    private final ImageDescriptor[] decos;
    private ImageDataProvider imageDataProvider;
    private ImageData mainData = null;
    private CompositeImageDescriptor.CachedImageDataProvider[] decosDataProvider = null;

    public N4JSDecoratorRow(ImageDescriptor main, int quadrant, List<ImageDescriptor> decos) {
        Objects.requireNonNull(main);
        if (quadrant < 0 || quadrant > 3) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(decos);
        this.main = main;
        this.quadrant = quadrant;
        this.decos = decos.toArray(new ImageDescriptor[decos.size()]);
    }

    public N4JSDecoratorRow(ImageDescriptor main, int quadrant, ImageDescriptor deco) {
        this(main, quadrant, Collections.singletonList(deco));
    }

    private boolean isDecoTop() {
        switch (this.quadrant) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    private boolean isDecoLeft() {
        switch (this.quadrant) {
            case 0: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private int halfDecoHeight() {
        return this.getDecosHeight() / 2;
    }

    private int halfDecoWidth() {
        return this.getDecosWidth() / 2;
    }

    private int shiftFromTop() {
        return this.isDecoTop() ? this.halfDecoHeight() : 0;
    }

    private int shiftFromLeft() {
        return this.isDecoLeft() ? this.halfDecoWidth() : 0;
    }

    private ImageData getMainData() {
        if (this.mainData == null) {
            this.mainData = this.main.getImageData(100);
        }
        return this.mainData;
    }

    private ImageDataProvider getImageDataProvider() {
        if (this.main == null) {
            return null;
        }
        if (this.imageDataProvider == null) {
            this.imageDataProvider = this.createCachedImageDataProvider(this.main);
        }
        return this.imageDataProvider;
    }

    private CompositeImageDescriptor.CachedImageDataProvider[] getDecosDataProvider() {
        if (this.decosDataProvider == null) {
            this.decosDataProvider = new CompositeImageDescriptor.CachedImageDataProvider[this.decos.length];
            int i = 0;
            while (i < this.decosDataProvider.length) {
                this.decosDataProvider[i] = this.createCachedImageDataProvider(this.decos[i]);
                ++i;
            }
        }
        return this.decosDataProvider;
    }

    private int getDecosWidth() {
        int result = 0;
        CompositeImageDescriptor.CachedImageDataProvider[] cachedImageDataProviderArray = this.getDecosDataProvider();
        int n = cachedImageDataProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompositeImageDescriptor.CachedImageDataProvider dd = cachedImageDataProviderArray[n2];
            result += dd.getWidth();
            ++n2;
        }
        return result;
    }

    private int getDecosHeight() {
        int result = 0;
        CompositeImageDescriptor.CachedImageDataProvider[] cachedImageDataProviderArray = this.getDecosDataProvider();
        int n = cachedImageDataProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompositeImageDescriptor.CachedImageDataProvider dd = cachedImageDataProviderArray[n2];
            result = Math.max(result, dd.getHeight());
            ++n2;
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.decos);
        result = 31 * result + (this.main == null ? 0 : this.main.hashCode());
        result = 31 * result + this.quadrant;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof N4JSDecoratorRow)) {
            return false;
        }
        N4JSDecoratorRow other = (N4JSDecoratorRow)((Object)obj);
        if (!Arrays.equals(this.decos, other.decos)) {
            return false;
        }
        if (!this.main.equals(other.main)) {
            return false;
        }
        return this.quadrant == other.quadrant;
    }

    private Rectangle getSizeOfShiftedMain() {
        int widthAfterShift = this.shiftFromLeft() + this.getMainData().width;
        int heightAfterShift = this.shiftFromTop() + this.getMainData().height;
        return new Rectangle(0, 0, widthAfterShift, heightAfterShift);
    }

    private Rectangle getSizeOfShiftedDecos() {
        int widthAfterShift = this.marginFromLeft() + this.getDecosWidth();
        int heightAfterShift = this.marginFromTop() + this.getDecosHeight();
        return new Rectangle(0, 0, widthAfterShift, heightAfterShift);
    }

    private int marginFromLeft() {
        return this.isDecoLeft() ? 0 : N4JSDecoratorRow.halfOf(this.getMainData().width);
    }

    private int marginFromTop() {
        return this.isDecoTop() ? 0 : N4JSDecoratorRow.halfOf(this.getMainData().height);
    }

    private static int halfOf(int amount) {
        return amount / 2;
    }

    protected Point getSize() {
        Rectangle boundingBox = this.getSizeOfShiftedMain().union(this.getSizeOfShiftedDecos());
        return new Point(boundingBox.width, boundingBox.height);
    }

    protected void drawCompositeImage(int ignoredWidth, int ignoredHeight) {
        this.drawImage(this.getImageDataProvider(), this.shiftFromLeft(), this.shiftFromTop());
        int x = this.marginFromLeft();
        int y = this.marginFromTop();
        CompositeImageDescriptor.CachedImageDataProvider[] cachedImageDataProviderArray = this.getDecosDataProvider();
        int n = cachedImageDataProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompositeImageDescriptor.CachedImageDataProvider decoDataProvider = cachedImageDataProviderArray[n2];
            this.drawImage((ImageDataProvider)decoDataProvider, x, y);
            x += decoDataProvider.getWidth();
            ++n2;
        }
    }
}

