/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xpect.text.ITextDifferencer;
import org.eclipse.xpect.text.TextDiffToString;
import org.eclipse.xpect.util.DifferencerImpl;
import org.eclipse.xpect.util.IDifferencer;

public class TextDifferencer
implements ITextDifferencer {
    protected DifferencerImpl createDifferencer() {
        return new DifferencerImpl();
    }

    protected <T> List<Segment> createSegments(List<T> tokens, ITextDifferencer.ITextDiffConfig<T> config) {
        ArrayList segments = Lists.newArrayList();
        int tokenIndex = 0;
        while (tokenIndex < tokens.size()) {
            T token = tokens.get(tokenIndex);
            for (String string : config.toSegments(token)) {
                int end;
                int index;
                boolean hidden = config.isHidden(token, string);
                int lastIndex = 0;
                while ((index = string.indexOf(10, lastIndex)) >= 0) {
                    int n = end = index > 0 && string.charAt(index - 1) == '\r' ? index - 1 : index;
                    if (lastIndex < end) {
                        segments.add(new Segment(tokenIndex, string.substring(lastIndex, end), hidden));
                    }
                    segments.add(new Segment(tokenIndex, string.substring(end, index + 1), true));
                    lastIndex = index + 1;
                }
                end = string.length();
                if (lastIndex >= end) continue;
                segments.add(new Segment(tokenIndex, string.substring(lastIndex, end), hidden));
            }
            ++tokenIndex;
        }
        if (!segments.isEmpty()) {
            Segment previous = (Segment)segments.get(0);
            int i = 1;
            while (i < segments.size()) {
                Segment seg = (Segment)segments.get(i);
                seg.previous = previous;
                previous.next = seg;
                previous = seg;
                ++i;
            }
        }
        ArrayList result = Lists.newArrayList();
        for (Segment s : segments) {
            if (s.isHidden()) continue;
            result.add(s);
        }
        return result;
    }

    @Override
    public <T> ITextDifferencer.ITextDiff diff(List<T> leftTokens, List<T> rightTokens, ITextDifferencer.ITextDiffConfig<T> config) {
        List<Segment> leftSegments = this.createSegments(leftTokens, config);
        List<Segment> rightSegments = this.createSegments(rightTokens, config);
        List<IDifferencer.Match> diff = this.createDifferencer().diff(leftSegments, rightSegments, config);
        ArrayList currentLine = Lists.newArrayList();
        ArrayList result = Lists.newArrayList();
        for (IDifferencer.Match match : diff) {
            Segment right;
            Segment left = match.getLeft() != -1 ? leftSegments.get(match.getLeft()) : null;
            Segment segment = right = match.getRight() != -1 ? rightSegments.get(match.getRight()) : null;
            if (left != null && left.needsWrap() || right != null && right.needsWrap()) {
                result.add(new LineDiff(currentLine));
                currentLine.clear();
            }
            currentLine.add(new SegmentDiff(match.getKind(), left, right, match.getSimilarity()));
        }
        if (!currentLine.isEmpty()) {
            result.add(new LineDiff(currentLine));
            currentLine.clear();
        }
        TextDiff textDiff = new TextDiff(result);
        return textDiff;
    }

    protected static class LineDiff
    implements ITextDifferencer.ILineDiff {
        private final IDifferencer.MatchKind kind;
        private final List<ITextDifferencer.ISegmentDiff> segmentDiffs;

        public LineDiff(List<? extends ITextDifferencer.ISegmentDiff> segmentDiffs) {
            this.segmentDiffs = ImmutableList.copyOf(segmentDiffs);
            this.kind = this.computeKind(this.segmentDiffs);
        }

        protected IDifferencer.MatchKind computeKind(List<ITextDifferencer.ISegmentDiff> lineMatches) {
            boolean hasLeft = false;
            boolean hasRight = false;
            for (ITextDifferencer.ISegmentDiff match : lineMatches) {
                switch (match.getKind()) {
                    case SIMILAR: {
                        return IDifferencer.MatchKind.SIMILAR;
                    }
                    case EQUAL: {
                        if (hasLeft != hasRight) {
                            return IDifferencer.MatchKind.SIMILAR;
                        }
                        hasLeft = true;
                        hasRight = true;
                        break;
                    }
                    case LEFT_ONLY: {
                        hasLeft = true;
                        if (!hasRight) break;
                        return IDifferencer.MatchKind.SIMILAR;
                    }
                    case RIGHT_ONLY: {
                        hasRight = true;
                        if (!hasLeft) break;
                        return IDifferencer.MatchKind.SIMILAR;
                    }
                }
            }
            if (hasLeft && hasRight) {
                return IDifferencer.MatchKind.EQUAL;
            }
            if (hasLeft) {
                return IDifferencer.MatchKind.LEFT_ONLY;
            }
            if (hasRight) {
                return IDifferencer.MatchKind.RIGHT_ONLY;
            }
            return IDifferencer.MatchKind.EQUAL;
        }

        @Override
        public IDifferencer.MatchKind getKind() {
            return this.kind;
        }

        @Override
        public List<ITextDifferencer.ISegmentDiff> getSegmentDiffs() {
            return this.segmentDiffs;
        }

        public String toString() {
            return new TextDiffToString().toPrefixedLine(this);
        }
    }

    protected static class Segment
    implements ITextDifferencer.ISegment {
        private final boolean hidden;
        private Segment next = null;
        private Segment previous = null;
        private final String string;
        private final int tokenIndex;

        public Segment(int tokenIndex, String string, boolean hidden) {
            Preconditions.checkArgument((string.length() > 0 ? 1 : 0) != 0);
            this.tokenIndex = tokenIndex;
            this.string = string;
            this.hidden = hidden;
        }

        @Override
        public int getTokenIndex() {
            return this.tokenIndex;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        public boolean needsWrap() {
            if (this.previous != null) {
                return this.previous.needsWrapHidden();
            }
            return false;
        }

        protected boolean needsWrapHidden() {
            if (!this.hidden) {
                return false;
            }
            if (this.isWrap()) {
                return true;
            }
            if (this.previous != null) {
                return this.previous.needsWrapHidden();
            }
            return false;
        }

        @Override
        public String toString() {
            return this.string;
        }

        @Override
        public ITextDifferencer.ISegment getNext() {
            return this.next;
        }

        @Override
        public ITextDifferencer.ISegment getPrevious() {
            return this.previous;
        }

        @Override
        public boolean isWrap() {
            return this.string.endsWith("\n");
        }
    }

    protected static class SegmentDiff
    implements ITextDifferencer.ISegmentDiff {
        private final IDifferencer.MatchKind kind;
        private final Segment left;
        private final Segment right;
        private final float similarity;

        public SegmentDiff(IDifferencer.MatchKind kind, Segment left, Segment right, float similarity) {
            this.left = left;
            this.right = right;
            this.kind = kind;
            this.similarity = similarity;
        }

        @Override
        public IDifferencer.MatchKind getKind() {
            return this.kind;
        }

        @Override
        public Segment getLeft() {
            return this.left;
        }

        @Override
        public Segment getRight() {
            return this.right;
        }

        @Override
        public float getSimilarity() {
            return this.similarity;
        }

        public String toString() {
            switch (this.kind) {
                case EQUAL: {
                    return this.left.toString();
                }
                case LEFT_ONLY: {
                    return "[" + this.left.toString() + "|]";
                }
                case RIGHT_ONLY: {
                    return "[|" + this.right.toString() + "]";
                }
                case SIMILAR: {
                    return "[" + this.left.toString() + "|" + this.right.toString() + "]";
                }
            }
            return super.toString();
        }
    }

    protected static class TextDiff
    implements ITextDifferencer.ITextDiff {
        private final List<ITextDifferencer.ILineDiff> lines;

        public TextDiff(List<? extends ITextDifferencer.ILineDiff> lines) {
            this.lines = ImmutableList.copyOf(lines);
        }

        @Override
        public List<ITextDifferencer.ILineDiff> getLines() {
            return this.lines;
        }

        public String toString() {
            return new TextDiffToString().apply(this);
        }
    }
}

