/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc;

import org.eclipse.n4js.jsdoc.AbstractJSDocParser;
import org.eclipse.n4js.jsdoc.DescriptionParser;
import org.eclipse.n4js.jsdoc.ITagDefinition;
import org.eclipse.n4js.jsdoc.JSDocCharScanner;
import org.eclipse.n4js.jsdoc.JSDocToken;
import org.eclipse.n4js.jsdoc.TagDictionary;
import org.eclipse.n4js.jsdoc.dom.ContentNode;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc.dom.DomFactory;
import org.eclipse.n4js.jsdoc.dom.LineTag;
import org.eclipse.n4js.jsdoc.dom.TagTitle;
import org.eclipse.n4js.jsdoc.tags.AbstractInlineTagDefinition;
import org.eclipse.n4js.jsdoc.tags.AbstractLineTagDefinition;
import org.eclipse.n4js.jsdoc.tokenizers.TagTitleTokenizer;

public class DocletParser
extends AbstractJSDocParser {
    TagDictionary<AbstractLineTagDefinition> lineTagDictionary;
    TagDictionary<AbstractInlineTagDefinition> inlineTagDictionary;
    DescriptionParser descriptionParser = null;

    public DocletParser(TagDictionary<AbstractLineTagDefinition> dict, TagDictionary<AbstractInlineTagDefinition> inlineDict) {
        this.lineTagDictionary = dict;
        this.inlineTagDictionary = inlineDict;
        this.descriptionParser = new DescriptionParser();
    }

    public TagDictionary<AbstractLineTagDefinition> getLineTagDictionary() {
        return this.lineTagDictionary;
    }

    public TagDictionary<AbstractInlineTagDefinition> getInlineTagDictionary() {
        return this.inlineTagDictionary;
    }

    public Doclet parse(String commentString) {
        JSDocToken token;
        JSDocCharScanner scanner = new JSDocCharScanner(commentString);
        Doclet doclet = this.parseMainDescription(scanner);
        TagTitleTokenizer tagTitleTokenizer = new TagTitleTokenizer();
        while ((token = tagTitleTokenizer.nextToken(scanner)) != null) {
            ITagDefinition tagDefinition = this.lineTagDictionary.getDefinition(token.token);
            int lineTagEnd = scanner.findLineTagEnd();
            scanner.fence(lineTagEnd + 1);
            if (tagDefinition != null) {
                TagTitle tagTitle = this.createTagTitle(token, tagDefinition);
                LineTag tag = (LineTag)tagDefinition.parse(tagTitle, scanner, this.descriptionParser);
                tag.setRange(token.start, scanner.offset());
                doclet.getLineTags().add((Object)tag);
            }
            scanner.unfence();
            scanner.setNextOffset(lineTagEnd);
        }
        doclet.setEnd(scanner.offset());
        return doclet;
    }

    private Doclet parseMainDescription(JSDocCharScanner scanner) {
        Doclet doclet = DomFactory.eINSTANCE.createDoclet();
        doclet.setBegin(scanner.offset());
        ContentNode description = this.descriptionParser.parse(scanner, this.inlineTagDictionary);
        if (description != null) {
            doclet.getContents().add((Object)description);
        }
        return doclet;
    }
}

