/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.n4js.resource.PostProcessingEntryTracker;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.OutdatedStateManager;
import org.eclipse.xtext.util.CancelIndicator;

public class PostProcessingAwareResource
extends DerivedStateAwareResource {
    @Inject(optional=true)
    private PostProcessor postProcessor;
    @Inject
    private OutdatedStateManager outdatedStateManager;
    protected volatile boolean fullyPostProcessed = false;
    protected volatile boolean isPostProcessing = false;
    private Throwable postProcessingThrowable;
    private final Queue<PostProcessingAwareResource> otherResourcesAwaitingFinalization = new LinkedList<PostProcessingAwareResource>();

    public boolean isFullyProcessed() {
        return this.fullyPostProcessed;
    }

    public boolean isPostProcessing() {
        return this.isPostProcessing;
    }

    public Throwable getPostProcessingThrowable() {
        return this.isFullyProcessed() ? this.postProcessingThrowable : null;
    }

    public void discardDerivedState() {
        this.discardPostProcessingResult();
        super.discardDerivedState();
    }

    protected void doUnload() {
        this.discardPostProcessingResult();
        super.doUnload();
    }

    public void resolveLazyCrossReferences(CancelIndicator cancelIndicator) {
        this.performPostProcessing(cancelIndicator);
    }

    public void performPostProcessing() {
        this.performPostProcessing(null);
    }

    /*
     * Unable to fully structure code
     */
    public void performPostProcessing(CancelIndicator cancelIndicator) {
        block14: {
            if (this.fullyPostProcessed) {
                return;
            }
            if (!this.isLoaded) {
                throw new IllegalStateException("The resource must be loaded, before PostProcessedResource#performPostProcessing() can be called.");
            }
            if (!this.fullyInitialized) {
                this.installDerivedState(false);
            }
            if (this.isLoaded && this.fullyInitialized && !this.fullyPostProcessed && !this.isPostProcessing) {
                if (cancelIndicator == null) {
                    cancelIndicator = this.outdatedStateManager.newCancelIndicator(this.getResourceSet());
                }
                if ((entryResource = PostProcessingEntryTracker.getEntryResource(this.getResourceSet())) != null) {
                    this.doMainPostProcessing(cancelIndicator);
                    entryResource.otherResourcesAwaitingFinalization.add(this);
                } else {
                    try {
                        try {
                            PostProcessingEntryTracker.setEntryResource(this);
                            this.doMainPostProcessing(cancelIndicator);
                            done = new HashSet<PostProcessingAwareResource>();
                            while ((other = this.otherResourcesAwaitingFinalization.poll()) != null) {
                                if (!done.add(other)) continue;
                                other.doFinalizePostProcessing(cancelIndicator);
                            }
                            this.doFinalizePostProcessing(cancelIndicator);
                            break block14;
                        }
                        catch (Throwable th) {
                            ** for (other : this.otherResourcesAwaitingFinalization)
                        }
lbl-1000:
                        // 1 sources

                        {
                            other.markAsPostProcessingDone();
                            continue;
                        }
lbl30:
                        // 1 sources

                        this.markAsPostProcessingDone();
                        throw th;
                    }
                    finally {
                        this.otherResourcesAwaitingFinalization.clear();
                        PostProcessingEntryTracker.unsetEntryResource(this.getResourceSet());
                    }
                }
            }
        }
    }

    private void doMainPostProcessing(CancelIndicator cancelIndicator) {
        try {
            this.postProcessingThrowable = null;
            this.isPostProcessing = true;
            if (this.postProcessor == null) {
                throw new IllegalStateException("post processor is null");
            }
            if (this.postProcessor.expectsLazyLinkResolution()) {
                super.resolveLazyCrossReferences(cancelIndicator);
            }
            this.postProcessor.performPostProcessing(this, cancelIndicator);
        }
        catch (Throwable th) {
            this.markAsPostProcessingDone();
            this.postProcessingThrowable = th;
            throw th;
        }
    }

    private void doFinalizePostProcessing(CancelIndicator cancelIndicator) {
        try {
            try {
                if (this.postProcessingThrowable == null) {
                    this.postProcessor.finalizePostProcessing(this, cancelIndicator);
                }
            }
            catch (Throwable th) {
                this.postProcessingThrowable = th;
                throw th;
            }
        }
        finally {
            this.markAsPostProcessingDone();
        }
    }

    public void discardPostProcessingResult() {
        if (this.fullyPostProcessed) {
            try {
                this.postProcessor.discardPostProcessingResult(this);
            }
            finally {
                this.fullyPostProcessed = false;
            }
        }
    }

    private void markAsPostProcessingDone() {
        this.isPostProcessing = false;
        this.fullyPostProcessed = true;
    }

    public static interface PostProcessor {
        default public boolean expectsLazyLinkResolution() {
            return true;
        }

        public void performPostProcessing(PostProcessingAwareResource var1, CancelIndicator var2);

        public void finalizePostProcessing(PostProcessingAwareResource var1, CancelIndicator var2);

        public void discardPostProcessingResult(PostProcessingAwareResource var1);
    }
}

