/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.resource.UserDataMapper;
import org.eclipse.n4js.scoping.utils.CanLoadFromDescriptionHelper;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.SchedulingRuleFactory;

public class N4JSDirtyStateEditorSupport
extends DirtyStateEditorSupport {
    private static ISchedulingRule SCHEDULING_RULE = SchedulingRuleFactory.INSTANCE.newSequence();
    public static final Object FAMILY_UPDATE_JOB = new Object();
    private N4JSUpdateEditorStateJob updateEditorStateJob;
    @Inject
    private CanLoadFromDescriptionHelper canLoadFromDescriptionHelper;
    @Inject
    private IResourceDescriptions dirtyState;

    protected N4JSUpdateEditorStateJob createUpdateEditorJob() {
        return new N4JSUpdateEditorStateJob(SCHEDULING_RULE);
    }

    public void scheduleUpdateEditorJob(IResourceDescription.Event event) {
        N4JSUpdateEditorStateJob job = this.updateEditorStateJob;
        if (job == null) {
            this.updateEditorStateJob = job = this.createUpdateEditorJob();
        }
        job.scheduleFor(event);
    }

    protected Collection<Resource> collectAffectedResources(XtextResource resource, IResourceDescription.Event event) {
        List<Resource> result = this.doCollectAffectedResources(resource, event);
        this.markResourcesAsLoaded(result);
        return result;
    }

    private void markResourcesAsLoaded(List<Resource> resources) {
        for (Resource affected : resources) {
            if (!(affected instanceof N4JSResource)) continue;
            ((N4JSResource)affected).forceSetLoaded();
        }
    }

    private List<Resource> doCollectAffectedResources(XtextResource resource, IResourceDescription.Event event) {
        Set<URI> deltaURIs = this.collectDeltaURIs(event);
        List<Resource> result = this.collectTransitivelyDependentResources(resource, deltaURIs);
        return result;
    }

    private List<Resource> collectTransitivelyDependentResources(XtextResource resource, Set<URI> deltaURIs) {
        ArrayList result = Lists.newArrayList();
        ResourceSet resourceSet = resource.getResourceSet();
        for (Resource candidate : resourceSet.getResources()) {
            if (candidate == resource) continue;
            URI uri = candidate.getURI();
            if (deltaURIs.contains(uri)) {
                result.add(candidate);
                continue;
            }
            if (!(candidate instanceof N4JSResource) || !this.canLoadFromDescriptionHelper.dependsOnAny(candidate, deltaURIs)) continue;
            result.add(candidate);
        }
        return result;
    }

    private Set<URI> collectDeltaURIs(IResourceDescription.Event event) {
        HashSet deltaURIs = Sets.newHashSet();
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            deltaURIs.add(delta.getUri());
        }
        return deltaURIs;
    }

    private boolean isSignificantChange(IResourceDescription.Delta delta) {
        if (delta.haveEObjectDescriptionsChanged()) {
            IResourceDescription oldDescription;
            IResourceDescription newDescription = delta.getNew();
            if (newDescription != null != ((oldDescription = delta.getOld()) != null)) {
                return true;
            }
            if (newDescription == null || oldDescription == null) {
                throw new IllegalStateException();
            }
            ArrayList newDescriptions = Lists.newArrayList((Iterable)newDescription.getExportedObjects());
            ArrayList oldDescriptions = Lists.newArrayList((Iterable)oldDescription.getExportedObjects());
            if (newDescriptions.size() != oldDescriptions.size()) {
                return true;
            }
            URI resourceURI = delta.getUri();
            int i = 0;
            while (i < newDescriptions.size()) {
                if (!this.equalDescriptions((IEObjectDescription)newDescriptions.get(i), (IEObjectDescription)oldDescriptions.get(i), resourceURI)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean equalDescriptions(IEObjectDescription newDescription, IEObjectDescription oldDescription, URI uri) {
        if (!newDescription.getQualifiedName().equals((Object)oldDescription.getQualifiedName())) {
            return false;
        }
        if (!newDescription.getEClass().equals(oldDescription.getEClass())) {
            return false;
        }
        if (!newDescription.getEObjectURI().equals(oldDescription.getEObjectURI())) {
            return false;
        }
        if (TypesPackage.Literals.TMODULE == newDescription.getEClass()) {
            String newModule = newDescription.getUserData("serializedScript");
            String oldModule = oldDescription.getUserData("serializedScript");
            if (newModule == null || oldModule == null) {
                return true;
            }
            if (!newModule.equals(oldModule)) {
                TModule newModuleObj = UserDataMapper.getDeserializedModuleFromDescription((IEObjectDescription)newDescription, (URI)uri);
                TModule oldModuleObj = UserDataMapper.getDeserializedModuleFromDescription((IEObjectDescription)oldDescription, (URI)uri);
                newModuleObj.setAstMD5("");
                oldModuleObj.setAstMD5("");
                if (!EcoreUtilN4.equalsNonResolving((EObject)newModuleObj, (EObject)oldModuleObj)) {
                    return false;
                }
            }
        }
        return true;
    }

    public void modelChanged(XtextResource resource) {
        if (resource == null || !this.getDirtyResource().isInitialized()) {
            return;
        }
        resource.getContents();
        super.modelChanged(resource);
    }

    public void descriptionsChanged(IResourceDescription.Event event) {
        if (!this.getDirtyResource().isInitialized()) {
            return;
        }
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            if (delta.getOld() != this.getDirtyResource().getDescription() && delta.getNew() != this.getDirtyResource().getDescription()) continue;
            if (this.canLoadFromDescriptionHelper.isPartOfDependencyCycle(delta.getUri(), this.dirtyState)) {
                this.scheduleUpdateEditorJob(event);
            }
            return;
        }
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            if (!this.isSignificantChange(delta)) continue;
            this.scheduleUpdateEditorJob(event);
            return;
        }
    }

    private class N4JSUpdateEditorStateJob
    extends DirtyStateEditorSupport.UpdateEditorStateJob {
        N4JSUpdateEditorStateJob(ISchedulingRule rule) {
            super((DirtyStateEditorSupport)N4JSDirtyStateEditorSupport.this, rule);
        }

        public boolean belongsTo(Object family) {
            return FAMILY_UPDATE_JOB == family;
        }

        protected void scheduleFor(IResourceDescription.Event event) {
            super.scheduleFor(event);
        }
    }
}

