/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.process.ProcessExecutionCommand;
import org.eclipse.n4js.utils.process.ProcessResult;

@Singleton
public class ProcessExecutionCommandStatus {
    @Inject
    private StatusHelper statusHelper;

    public IStatus execute(Supplier<ProcessExecutionCommand> commandSupplier, String msg) {
        ProcessResult per = commandSupplier.get().execute();
        if (per.isOK()) {
            return Status.OK_STATUS;
        }
        Throwable cause = per.toThrowable(msg);
        if (cause != null) {
            return this.statusHelper.createError(cause.getMessage(), cause);
        }
        return this.statusHelper.createError(per.toString(), cause);
    }

    public <T> IStatus execute(T t, Function<T, ProcessExecutionCommand> operation, String msg) {
        return this.execute(() -> (ProcessExecutionCommand)operation.apply(t), msg);
    }

    public <T, U> IStatus execute(T t, U u, BiFunction<T, U, ProcessExecutionCommand> operation, String msg) {
        return this.execute(() -> (ProcessExecutionCommand)operation.apply(t, u), msg);
    }
}

