/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.ui.text.ChainElementAnalyzer;
import org.eclipse.jdt.internal.ui.text.ChainType;
import org.eclipse.osgi.util.NLS;

public class ChainElement {
    private final IJavaElement element;
    private ChainType returnType;
    private int dimension;
    private ElementType elementType;
    private final boolean requireThis;

    public ChainElement(IJavaElement element, boolean requireThis) {
        if (element == null) {
            throw new IllegalArgumentException("???");
        }
        this.element = element;
        this.requireThis = requireThis;
        this.initializeReturnType();
    }

    private void initializeReturnType() {
        String signature = null;
        IJavaProject proj = this.element.getJavaProject();
        switch (this.element.getElementType()) {
            case 8: {
                this.elementType = ElementType.FIELD;
                try {
                    signature = ((IField)this.element).getTypeSignature();
                }
                catch (JavaModelException javaModelException) {}
                IType declType = ((IField)this.element).getDeclaringType();
                this.setReturnType(proj, signature, declType);
                break;
            }
            case 14: {
                this.elementType = ElementType.LOCAL_VARIABLE;
                signature = ((ILocalVariable)this.element).getTypeSignature();
                IType declType = ((ILocalVariable)this.element).getDeclaringMember().getDeclaringType();
                this.setReturnType(proj, signature, declType);
                break;
            }
            case 9: {
                this.elementType = ElementType.METHOD;
                try {
                    signature = ((IMethod)this.element).getReturnType();
                }
                catch (JavaModelException javaModelException) {}
                IType declType = ((IMethod)this.element).getDeclaringType();
                this.setReturnType(proj, signature, declType);
                break;
            }
            case 7: {
                this.elementType = ElementType.TYPE;
                this.returnType = new ChainType((IType)this.element);
                break;
            }
            default: {
                JavaManipulationPlugin.logErrorMessage(NLS.bind((String)"Cannot handle {0} as return type.", (Object)this.element));
            }
        }
        this.dimension = signature == null ? 0 : Signature.getArrayCount((String)signature);
    }

    private void setReturnType(IJavaProject proj, String signature, IType declType) {
        IType res;
        this.returnType = ChainElementAnalyzer.isPrimitive(signature) ? new ChainType(signature) : ((res = ChainElementAnalyzer.getTypeFromSignature(proj, signature, declType)) != null ? new ChainType(res) : new ChainType(signature));
    }

    public IJavaElement getElement() {
        return this.element;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ChainType getReturnType() {
        return this.returnType;
    }

    public int getReturnTypeDimension() {
        return this.dimension;
    }

    public boolean requiresThisForQualification() {
        return this.requireThis;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChainElement) {
            ChainElement other = (ChainElement)obj;
            return this.element.equals(other.element);
        }
        return false;
    }

    public String toString() {
        if (this.elementType == ElementType.METHOD) {
            IMethod m = (IMethod)this.element;
            StringBuilder ret = new StringBuilder(m.getElementName());
            try {
                return ret.append(m.getSignature()).toString();
            }
            catch (JavaModelException javaModelException) {
                return ret.toString();
            }
        }
        return this.element.toString();
    }

    public static enum ElementType {
        METHOD,
        FIELD,
        LOCAL_VARIABLE,
        TYPE;

    }
}

