/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.ui.injector;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public abstract class AbstractGuiceUIPlugin
extends AbstractUIPlugin {
    protected static AbstractGuiceUIPlugin INSTANCE;
    private final LoadingCache<String, Injector> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Injector>(){

        public Injector load(String id) throws Exception {
            Injector parentInjector = AbstractGuiceUIPlugin.this.getParentInjector(id);
            return parentInjector.createChildInjector(AbstractGuiceUIPlugin.this.getModules());
        }
    });

    public final void start(BundleContext context) throws Exception {
        this.beforeStart();
        this.doStart(context);
        INSTANCE = this;
        this.afterStart();
    }

    public final void stop(BundleContext context) throws Exception {
        this.beforeStop();
        INSTANCE = null;
        this.doStop(context);
        this.afterStop();
    }

    protected Injector getInjector(String id) {
        return (Injector)this.cache.getUnchecked((Object)id);
    }

    protected abstract Injector getParentInjector(String var1);

    protected Iterable<Module> getModules() {
        return Collections.emptyList();
    }

    protected void beforeStart() {
    }

    protected void doStart(BundleContext context) throws Exception {
        super.start(context);
    }

    protected void afterStart() {
    }

    protected void beforeStop() {
    }

    protected void doStop(BundleContext context) throws Exception {
        super.stop(context);
    }

    protected void afterStop() {
    }
}

