/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.BinariesProvider;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.utils.StatusHelper;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

@Singleton
public class OsgiBinariesPreferenceStore
extends BinariesPreferenceStore {
    private static final Logger LOGGER = Logger.getLogger(OsgiBinariesPreferenceStore.class);
    private static final String QUALIFIER = OsgiBinariesPreferenceStore.class.getName();
    @Inject
    private BinariesProvider binariesProvider;
    @Inject
    private StatusHelper statusHelper;

    @Override
    public IStatus save() {
        try {
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode(QUALIFIER);
            for (Map.Entry<Binary, URI> entry : this.getOrCreateState().entrySet()) {
                URI path = entry.getValue();
                if (path != null) {
                    File file = new File(path);
                    if (!file.isDirectory()) continue;
                    node.put(entry.getKey().getId(), file.getAbsolutePath());
                    continue;
                }
                node.put(entry.getKey().getId(), "");
            }
            node.flush();
            return Status.OK_STATUS;
        }
        catch (BackingStoreException e) {
            String message = "Unexpected error when trying to persist binary preferences.";
            LOGGER.error((Object)"Unexpected error when trying to persist binary preferences.", (Throwable)e);
            return this.statusHelper.createError("Unexpected error when trying to persist binary preferences.", e);
        }
    }

    @Override
    protected Map<Binary, URI> init() {
        Map<Binary, URI> initState = super.init();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(QUALIFIER);
        for (Binary binary : this.binariesProvider.getRegisteredBinaries()) {
            this.recursivePreferencesRead(initState, (Preferences)node, binary);
        }
        return initState;
    }

    private void recursivePreferencesRead(Map<Binary, URI> state, Preferences node, Binary binary) {
        File file;
        String value = node.get(binary.getId(), "");
        if (!Strings.isNullOrEmpty((String)value) && (file = new File(value)).isDirectory()) {
            state.put(binary, file.toURI());
        }
        binary.getChildren().forEach(child -> this.recursivePreferencesRead(state, node, (Binary)child));
    }
}

