/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.parser;

import org.eclipse.n4js.conversion.AbstractN4JSStringValueConverter;
import org.eclipse.n4js.conversion.CompositeSyntaxErrorMessages;
import org.eclipse.n4js.conversion.LegacyOctalIntValueConverter;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.conversion.RegExLiteralConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider;
import org.eclipse.xtext.parser.antlr.SyntaxErrorMessageProvider;

public class BadEscapementAwareMessageProvider
extends SyntaxErrorMessageProvider {
    public SyntaxErrorMessage getSyntaxErrorMessage(ISyntaxErrorMessageProvider.IValueConverterErrorContext context) {
        ValueConverterException cause = context.getValueConverterException();
        if (cause instanceof AbstractN4JSStringValueConverter.BadEscapementException) {
            if (((AbstractN4JSStringValueConverter.BadEscapementException)cause).isError()) {
                return new SyntaxErrorMessage(context.getDefaultMessage(), "N4JSStringValueConverter.bad.escapement.error");
            }
            return new SyntaxErrorMessage(context.getDefaultMessage(), "N4JSStringValueConverter.bad.escapement.warn");
        }
        if (cause instanceof LegacyOctalIntValueConverter.LeadingZerosException) {
            return new SyntaxErrorMessage(context.getDefaultMessage(), "N4JSStringValueConverter.bad.escapement.warn");
        }
        if (cause instanceof N4JSValueConverterWithValueException) {
            return CompositeSyntaxErrorMessages.toSyntaxErrorMessage((N4JSValueConverterWithValueException)cause, vce -> {
                if (vce instanceof RegExLiteralConverter.BogusRegExLiteralException) {
                    return this.createRangedSyntaxErrorMessage(vce.getMessage(), "RegExLiteralConverter.bogus.regex", vce.getOffset(), vce.getLength());
                }
                String issueCode = vce.getIssueCode();
                if (vce.hasRange()) {
                    return this.createRangedSyntaxErrorMessage(vce.getMessage(), issueCode, vce.getOffset(), vce.getLength());
                }
                return new SyntaxErrorMessage(vce.getMessage(), issueCode);
            });
        }
        return super.getSyntaxErrorMessage(context);
    }

    private SyntaxErrorMessage createRangedSyntaxErrorMessage(String message, String issueCode, int offset, int length) {
        String range = String.valueOf(offset) + ":" + length;
        return new SyntaxErrorMessage(message, issueCode, new String[]{range});
    }
}

