/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class RuntimeDependencyValidator
extends AbstractN4JSDeclarativeValidator {
    private static final String INDENT = "    ";
    @Inject
    private JavaScriptVariantHelper javaScriptVariantHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkIllegalLoadtimeReference(IdentifierRef idRef) {
        boolean hasCycle;
        boolean _not;
        boolean _isTopLevelCode = N4JSASTUtils.isTopLevelCode((EObject)idRef);
        boolean bl = _not = !_isTopLevelCode;
        if (_not) {
            return;
        }
        TModule targetModule = this.getTargetModule(idRef);
        if (targetModule == null) {
            return;
        }
        Resource _eResource = idRef.eResource();
        TModule containingModule = ((N4JSResource)_eResource).getModule();
        boolean bl2 = hasCycle = targetModule == containingModule && !containingModule.getCyclicModulesRuntime().isEmpty() || targetModule != containingModule && containingModule.getCyclicModulesRuntime().contains((Object)targetModule);
        if (hasCycle) {
            String _messageForLTD_ILLEGAL_LOADTIME_REFERENCE = IssueCodes.getMessageForLTD_ILLEGAL_LOADTIME_REFERENCE();
            String _plus = String.valueOf(_messageForLTD_ILLEGAL_LOADTIME_REFERENCE) + "\n";
            String _dependencyCycleToString = this.dependencyCycleToString(containingModule, false, INDENT);
            String message = String.valueOf(_plus) + _dependencyCycleToString;
            this.addIssue(message, (EObject)idRef, "LTD_ILLEGAL_LOADTIME_REFERENCE");
        }
    }

    @Check
    public void checkIllegalImportOfLTDTarget(Script script) {
        TModule containingModule = script.getModule();
        List importDecls = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)script.getScriptElements(), ImportDeclaration.class));
        HashSet<TModule> modulesInHealedCycles = new HashSet<TModule>();
        for (ImportDeclaration importDecl : importDecls) {
            boolean _not;
            boolean _isRetainedAtRuntime;
            if (!this.holdsNotAnIllegalImportWithinLoadtimeCycle(containingModule, importDecl) || !this.holdsNotAnIllegalImportOfLTDTarget(containingModule, importDecl, modulesInHealedCycles) || !(_isRetainedAtRuntime = importDecl.isRetainedAtRuntime())) continue;
            TModule targetModule = importDecl.getModule();
            boolean _isEmpty = targetModule.getCyclicModulesRuntime().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            modulesInHealedCycles.add(targetModule);
            EList _cyclicModulesRuntime = targetModule.getCyclicModulesRuntime();
            Iterables.addAll(modulesInHealedCycles, (Iterable)_cyclicModulesRuntime);
        }
    }

    private boolean holdsNotAnIllegalImportWithinLoadtimeCycle(TModule containingModule, ImportDeclaration importDecl) {
        TModule targetModule = importDecl.getModule();
        boolean _contains = containingModule.getCyclicModulesLoadtimeForInheritance().contains((Object)targetModule);
        if (_contains) {
            String _messageForLTD_LOADTIME_DEPENDENCY_CYCLE = IssueCodes.getMessageForLTD_LOADTIME_DEPENDENCY_CYCLE();
            String _plus = String.valueOf(_messageForLTD_LOADTIME_DEPENDENCY_CYCLE) + "\n";
            String _dependencyCycleToString = this.dependencyCycleToString(targetModule, true, INDENT);
            String message = String.valueOf(_plus) + _dependencyCycleToString;
            this.addIssue(message, (EObject)importDecl, (EStructuralFeature)N4JSPackage.eINSTANCE.getImportDeclaration_Module(), "LTD_LOADTIME_DEPENDENCY_CYCLE", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsNotAnIllegalImportOfLTDTarget(TModule containingModule, ImportDeclaration importDecl, Set<TModule> modulesInHealedCycles) {
        boolean isMultiLTDTarget;
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        boolean _isRetainedAtRuntime = importDecl.isRetainedAtRuntime();
        boolean bl = _not = !_isRetainedAtRuntime;
        if (_not) {
            return true;
        }
        TModule targetModule = importDecl.getModule();
        boolean _isLTDTarget = this.isLTDTarget(targetModule);
        boolean bl2 = _not_1 = !_isLTDTarget;
        if (_not_1) {
            return true;
        }
        boolean _isEmpty = targetModule.getCyclicModulesLoadtimeForInheritance().isEmpty();
        boolean bl3 = _not_2 = !_isEmpty;
        if (_not_2) {
            return true;
        }
        EList ltdSources = targetModule.getRuntimeCyclicLoadtimeDependents();
        boolean isSingletonLTDTarget = ltdSources.size() == 1 && !containingModule.equals(Iterables.getFirst((Iterable)ltdSources, null));
        int _size = ltdSources.size();
        boolean bl4 = isMultiLTDTarget = _size > 1;
        if (isSingletonLTDTarget || isMultiLTDTarget) {
            boolean _not_3;
            boolean _contains = modulesInHealedCycles.contains(targetModule);
            boolean bl5 = _not_3 = !_contains;
            if (_not_3) {
                boolean withinSameDependencyCycleCluster = targetModule.getCyclicModulesRuntime().contains((Object)containingModule);
                if (withinSameDependencyCycleCluster) {
                    String otherLTDSources = this.otherLTDSourcesToString(containingModule, targetModule);
                    String _messageForLTD_LOADTIME_DEPENDENCY_CONFLICT = IssueCodes.getMessageForLTD_LOADTIME_DEPENDENCY_CONFLICT(targetModule.getSimpleName(), otherLTDSources);
                    String _plus = String.valueOf(_messageForLTD_LOADTIME_DEPENDENCY_CONFLICT) + "\n";
                    String _plus_1 = String.valueOf(_plus) + "Containing runtime dependency cycle cluster:\n";
                    String _dependencyCycleToString = this.dependencyCycleToString(targetModule, false, INDENT);
                    String message = String.valueOf(_plus_1) + _dependencyCycleToString;
                    this.addIssue(message, (EObject)importDecl, (EStructuralFeature)N4JSPackage.eINSTANCE.getImportDeclaration_Module(), "LTD_LOADTIME_DEPENDENCY_CONFLICT", new String[0]);
                    return false;
                }
                String healingModulesStr = this.healingModulesToString(targetModule);
                String _messageForLTD_IMPORT_OF_LOADTIME_DEPENDENCY_TARGET = IssueCodes.getMessageForLTD_IMPORT_OF_LOADTIME_DEPENDENCY_TARGET(targetModule.getSimpleName(), healingModulesStr);
                String _plus_2 = String.valueOf(_messageForLTD_IMPORT_OF_LOADTIME_DEPENDENCY_TARGET) + "\n";
                String _plus_3 = String.valueOf(_plus_2) + "Containing runtime dependency cycle cluster:\n";
                String _dependencyCycleToString_1 = this.dependencyCycleToString(targetModule, false, INDENT);
                String message_1 = String.valueOf(_plus_3) + _dependencyCycleToString_1;
                this.addIssue(message_1, (EObject)importDecl, (EStructuralFeature)N4JSPackage.eINSTANCE.getImportDeclaration_Module(), "LTD_IMPORT_OF_LOADTIME_DEPENDENCY_TARGET", new String[0]);
                return true;
            }
        }
        return true;
    }

    private TModule getTargetModule(IdentifierRef idRef) {
        boolean _not;
        IdentifiableElement target = idRef.getTargetElement();
        if (target == null || target.eIsProxy()) {
            return null;
        }
        boolean _hasRuntimeRepresentation = N4JSLanguageUtils.hasRuntimeRepresentation(target, this.javaScriptVariantHelper);
        boolean bl = _not = !_hasRuntimeRepresentation;
        if (_not) {
            return null;
        }
        TModule targetModule = (TModule)EcoreUtil2.getContainerOfType((EObject)target, TModule.class);
        if (targetModule != null) {
            return targetModule;
        }
        Script targetScript = (Script)EcoreUtil2.getContainerOfType((EObject)target, Script.class);
        if (targetScript != null) {
            return targetScript.getModule();
        }
        return null;
    }

    private String otherLTDSourcesToString(TModule module, TModule ltdTarget) {
        Functions.Function1 _function = it -> it != module;
        List otherSources = this.sortModules(IterableExtensions.filter((Iterable)ltdTarget.getRuntimeCyclicLoadtimeDependents(), (Functions.Function1)_function));
        String _xifexpression = null;
        int _size = otherSources.size();
        boolean _greaterThan = _size > 1;
        _xifexpression = _greaterThan ? "modules " : "module ";
        String prefix = _xifexpression;
        Functions.Function1 _function_1 = it -> it.getSimpleName();
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(otherSources, (Functions.Function1)_function_1), (CharSequence)", ");
        return String.valueOf(prefix) + _join;
    }

    private String healingModulesToString(TModule module) {
        Functions.Function1 _function = it -> {
            boolean _isLTDTarget = this.isLTDTarget((TModule)it);
            return !_isLTDTarget;
        };
        List healingModules = this.sortModules(IterableExtensions.filter((Iterable)module.getCyclicModulesRuntime(), (Functions.Function1)_function));
        String _xifexpression = null;
        int _size = healingModules.size();
        boolean _greaterThan = _size > 1;
        _xifexpression = _greaterThan ? "one of the modules " : "module ";
        String prefix = _xifexpression;
        Functions.Function1 _function_1 = it -> it.getSimpleName();
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(healingModules, (Functions.Function1)_function_1), (CharSequence)", ");
        return String.valueOf(prefix) + _join;
    }

    private String dependencyCycleToString(TModule module, boolean onlyLoadtimeForInheritance, CharSequence indent) {
        EList _xifexpression = null;
        _xifexpression = onlyLoadtimeForInheritance ? module.getCyclicModulesLoadtimeForInheritance() : module.getCyclicModulesRuntime();
        EList cyclicModulesToUse = _xifexpression;
        LinkedHashSet<TModule> cyclicModules = new LinkedHashSet<TModule>((Collection<TModule>)cyclicModulesToUse);
        boolean _isEmpty = cyclicModules.isEmpty();
        if (_isEmpty) {
            return null;
        }
        cyclicModules.add(module);
        StringBuilder sb = new StringBuilder();
        List _sortModules = this.sortModules(cyclicModules);
        for (TModule cyclicModule : _sortModules) {
            boolean _greaterThan;
            int _length = sb.length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                sb.append("\n");
            }
            sb.append(indent);
            if (!onlyLoadtimeForInheritance && this.isLTDTarget(cyclicModule)) {
                sb.append("*");
            }
            sb.append(this.getFileName(cyclicModule));
            sb.append(" --> ");
            int listStart = sb.length();
            Functions.Function1 _function = it -> it.getTarget();
            List targetsOfRuntimeDeps = ListExtensions.map((List)cyclicModule.getDependenciesRuntime(), (Functions.Function1)_function);
            List _sortModules_1 = this.sortModules(targetsOfRuntimeDeps);
            for (TModule requiredModule : _sortModules_1) {
                boolean _greaterThan_1;
                boolean _contains = cyclicModules.contains(requiredModule);
                if (!_contains) continue;
                int _length_1 = sb.length();
                boolean bl2 = _greaterThan_1 = _length_1 > listStart;
                if (_greaterThan_1) {
                    sb.append(", ");
                }
                sb.append(this.getFileName(requiredModule));
            }
        }
        return sb.toString();
    }

    private <T extends TModule> List<T> sortModules(Iterable<T> modules) {
        Comparator _function = (m1, m2) -> CharSequence.compare(m1.getSimpleName(), m2.getSimpleName());
        return IterableExtensions.sortWith(modules, (Comparator)_function);
    }

    private boolean isLTDTarget(TModule module) {
        boolean _isEmpty = module.getRuntimeCyclicLoadtimeDependents().isEmpty();
        return !_isEmpty;
    }

    private String getFileName(TModule module) {
        Resource _eResource = null;
        if (module != null) {
            _eResource = module.eResource();
        }
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        String _lastSegment = null;
        if (_uRI != null) {
            _lastSegment = _uRI.lastSegment();
        }
        return _lastSegment;
    }
}

