/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import java.io.File;
import java.util.Collection;
import org.eclipse.n4js.jsdoc2spec.CopyrightHeader;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecSection;

public abstract class SpecFile
implements Comparable<SpecFile> {
    final String fileKey;
    final File file;

    public SpecFile(File file) {
        this.file = file;
        this.fileKey = file.toString();
    }

    public File getFile() {
        return this.file;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public abstract String getPackageDisplayName();

    public abstract String getNewContent();

    public abstract void add(SpecSection var1);

    public abstract Collection<? extends SpecSection> getSpecSections();

    public abstract int getOffsetStart(SpecSection var1);

    public abstract int getOffsetEnd(SpecSection var1);

    public String getCopyrightHeader() {
        return CopyrightHeader.getAdoc();
    }

    public int hashCode() {
        return this.getFile() != null ? this.getFile().hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpecFile) {
            SpecFile scf = (SpecFile)obj;
            if (this.getFile() != null) {
                return this.getFile().equals(scf.getFile());
            }
            return this.getFile() == scf.getFile();
        }
        return false;
    }

    @Override
    public int compareTo(SpecFile o) {
        if (o == null) {
            return 1;
        }
        if (this.getFile() == null) {
            return o.getFile() == null ? 0 : -1;
        }
        String myName = String.valueOf(this.getFile().getName()) + this.getFileKey();
        String otherName = String.valueOf(o.getFile().getName()) + o.getFileKey();
        return myName.compareTo(otherName);
    }

    public String toString() {
        return this.getFileKey();
    }
}

