/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.product;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.WorkbenchActionBuilder;

public class N4JSApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final Predicate<MenuManager> PROJECT_MENU_PREDICATE = i -> "project".equals(i.getId());
    private static final Predicate<MenuManager> WORKING_SET_MENU_PREDICATE = i -> IDEWorkbenchMessages.Workbench_buildSet.equals(i.getMenuText());
    private final WorkbenchActionBuilder delegate;
    private final IActionBarConfigurer configurer;

    public N4JSApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        this.delegate = new WorkbenchActionBuilder(configurer);
        this.configurer = configurer;
    }

    public IStatus saveState(IMemento memento) {
        return this.delegate.saveState(memento);
    }

    public void fillActionBars(int flags) {
        this.delegate.fillActionBars(flags);
        IMenuManager menuManager = this.configurer.getMenuManager();
        MenuManager projectManager = this.getMenuManager(PROJECT_MENU_PREDICATE, (IContributionManager)menuManager);
        if (projectManager != null) {
            MenuManager workingSetManager = this.getMenuManager(WORKING_SET_MENU_PREDICATE, (IContributionManager)projectManager);
            projectManager.remove((IContributionItem)workingSetManager);
            projectManager.update(true);
        }
    }

    public IStatus restoreState(IMemento memento) {
        return this.delegate.restoreState(memento);
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public boolean isApplicationMenu(String menuId) {
        return this.delegate.isApplicationMenu(menuId);
    }

    private MenuManager getMenuManager(Predicate<MenuManager> predicate, IContributionManager manager) {
        return (MenuManager)FluentIterable.from(Arrays.asList(manager.getItems())).filter(MenuManager.class).firstMatch(predicate).orNull();
    }
}

