/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.runner.XpectURIProvider;
import org.eclipse.xpect.util.IBundleInfo;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@XpectURIProvider(value=XpectTestFileCollector.class)
public @interface XpectTestFiles {
    public String baseDir() default "";

    public String[] fileExtensions() default {"xt", "xpect"};

    public String[] files() default {};

    public FileRoot relativeTo() default FileRoot.CLASS;

    public static class Builder
    implements XpectTestFiles {
        private String baseDir = "";
        private List<String> files = Lists.newArrayList();
        private FileRoot relativeTo = FileRoot.CLASS;

        public Builder addFile(String file) {
            this.files.add(file);
            return this;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return XpectTestFiles.class;
        }

        @Override
        public String baseDir() {
            return this.baseDir;
        }

        public IXpectURIProvider create(Class<?> owner) {
            return new XpectTestFileCollector(owner, this);
        }

        @Override
        public String[] fileExtensions() {
            return new String[]{"xt"};
        }

        @Override
        public String[] files() {
            return this.files.toArray(new String[this.files.size()]);
        }

        @Override
        public FileRoot relativeTo() {
            return this.relativeTo;
        }

        public Builder relativeTo(FileRoot relativeTo) {
            this.relativeTo = relativeTo;
            return this;
        }

        public Builder withBaseDir(String baseDir) {
            this.baseDir = baseDir;
            return this;
        }
    }

    public static enum FileRoot {
        CLASS,
        CURRENT,
        PROJECT,
        SOURCE;

    }

    public static class XpectTestFileCollector
    implements IXpectURIProvider {
        protected final XpectTestFiles ctx;
        protected final Class<?> owner;
        protected IBundleInfo project;

        protected XpectTestFileCollector(Class<?> owner, XpectTestFiles ctx) {
            this.owner = owner;
            this.ctx = ctx;
        }

        protected URI createURI(File file) {
            return URI.createFileURI((String)file.getAbsolutePath());
        }

        @Override
        public URI deresolveToProject(URI uri) {
            return uri.deresolve(this.getBundle().getRootURI());
        }

        @Override
        public Collection<URI> getAllURIs() {
            IBundleInfo bundle = this.getBundle();
            IBundleInfo.Context context = this.getContext();
            ArrayList result = Lists.newArrayList();
            String localPath = this.getLocalPath();
            if (this.ctx.files().length == 0) {
                result.addAll(bundle.find(context, localPath, (Predicate<String>)Predicates.alwaysTrue(), this.ctx.fileExtensions()));
            } else {
                String[] stringArray = this.ctx.files();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    if (!Strings.isNullOrEmpty((String)localPath)) {
                        file = String.valueOf(localPath) + "/" + file;
                    }
                    result.add(bundle.find(context, file));
                    ++n2;
                }
            }
            return result;
        }

        protected IBundleInfo getBundle() {
            IBundleInfo.Registry registry = IBundleInfo.Registry.INSTANCE;
            if (this.ctx.relativeTo() == FileRoot.CURRENT) {
                return registry.getBundle(URI.createFileURI((String)new File(".").getAbsoluteFile().getParent()));
            }
            return this.getProject();
        }

        protected IBundleInfo.Context getContext() {
            switch (this.ctx.relativeTo()) {
                case CLASS: 
                case SOURCE: {
                    return IBundleInfo.Context.SOURCE;
                }
                case CURRENT: 
                case PROJECT: {
                    return IBundleInfo.Context.ROOT;
                }
            }
            return IBundleInfo.Context.ROOT;
        }

        protected String getLocalPath() {
            ArrayList segments = Lists.newArrayList();
            if (this.ctx.relativeTo() == FileRoot.CLASS) {
                Collections.addAll(segments, this.owner.getPackage().getName().split("\\."));
            }
            if (!Strings.isNullOrEmpty((String)this.ctx.baseDir())) {
                Collections.addAll(segments, this.ctx.baseDir().split("/"));
            }
            return Joiner.on((char)'/').join((Iterable)segments);
        }

        protected IBundleInfo getProject() {
            if (this.project == null) {
                this.project = IBundleInfo.Registry.INSTANCE.getBundle(this.owner);
            }
            return this.project;
        }

        protected URI resolvePlatformResourceURI(URI uri) {
            List segments = uri.segmentsList();
            if (segments.size() < 2) {
                throw new RuntimeException("URI " + uri + " has an invalid format");
            }
            String symbolicName = (String)segments.get(1);
            IBundleInfo bundle = IBundleInfo.Registry.INSTANCE.getBundle(symbolicName);
            if (bundle == null) {
                throw new RuntimeException("Bundle " + symbolicName + " not found.");
            }
            URI uriInBundle = URI.createURI((String)Joiner.on((char)'/').join(segments.subList(2, segments.size())));
            return uriInBundle.resolve(bundle.getRootURI());
        }

        protected URI resolveProjectRelativeURI(URI uri) {
            List segments = uri.segmentsList();
            URI uriInProject = URI.createURI((String)Joiner.on((char)'/').join((Iterable)segments));
            return uriInProject.resolve(this.getProject().getRootURI());
        }

        @Override
        public URI resolveURI(URI base, String newURI) {
            URI uri = URI.createURI((String)newURI);
            if (uri.isPlatformResource()) {
                return this.resolvePlatformResourceURI(uri);
            }
            if (uri.hasAbsolutePath()) {
                return this.resolveProjectRelativeURI(uri);
            }
            return uri.resolve(base);
        }

        public String toString() {
            ArrayList items = Lists.newArrayList();
            items.add("relativeTo=" + this.ctx.relativeTo().name());
            if (this.ctx.files().length > 0) {
                items.add("files=" + Joiner.on((String)",").join((Object[])this.ctx.files()));
            }
            if (!Strings.isNullOrEmpty((String)this.ctx.baseDir())) {
                items.add("baseDir=" + this.ctx.baseDir());
            }
            items.add("fileExtensions=" + Joiner.on((String)",").join((Object[])this.ctx.fileExtensions()));
            return "@" + XpectTestFiles.class.getSimpleName() + "(" + Joiner.on((String)", ").join((Iterable)items) + ")";
        }
    }
}

