/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist.imports;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ide.editor.contentassist.imports.AliasLocation;
import org.eclipse.n4js.ide.editor.contentassist.imports.ImportSpacerUserPreferenceHelper;
import org.eclipse.n4js.ide.editor.contentassist.imports.ImportsRegionHelper;
import org.eclipse.n4js.ide.editor.contentassist.imports.NameAndAlias;
import org.eclipse.n4js.ide.editor.contentassist.imports.XReplaceRegion;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.utils.Lazy;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;

public class ImportRewriter {
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IValueConverterService valueConverters;
    @Inject
    private N4JSGrammarAccess grammarAccess;
    @Inject
    private ImportsRegionHelper importsRegionHelper;
    @Inject
    private ImportSpacerUserPreferenceHelper spacerPreference;

    public ImportChanges create(String lineDelimiter, Resource resource) {
        ImportChanges result = new ImportChanges(lineDelimiter, resource);
        return result;
    }

    static /* synthetic */ ImportSpacerUserPreferenceHelper access$0(ImportRewriter importRewriter) {
        return importRewriter.spacerPreference;
    }

    public class ImportChanges {
        private final String lineDelimiter;
        private final Script script;
        private final Set<NameAndAlias> requestedImports;
        private final List<ImportDeclaration> existingImports;
        private final Lazy<String> lazySpacer;

        private ImportChanges(String lineDelimiter, Resource resource) {
            this.lineDelimiter = lineDelimiter;
            this.script = (Script)resource.getContents().get(0);
            this.existingImports = Lists.newArrayList();
            for (ScriptElement element : this.script.getScriptElements()) {
                if (!(element instanceof ImportDeclaration)) continue;
                this.existingImports.add((ImportDeclaration)element);
            }
            this.requestedImports = Sets.newLinkedHashSet();
            this.lazySpacer = new Lazy(() -> ImportRewriter.this.spacerPreference.getSpacingPreference(resource));
        }

        public void addImport(QualifiedName qualifiedName) {
            this.requestedImports.add(new NameAndAlias(qualifiedName, null));
        }

        public void addImport(QualifiedName qualifiedName, String alias) {
            this.requestedImports.add(new NameAndAlias(qualifiedName, alias));
        }

        public void addSingleImport(QualifiedName qualifiedName, Collection<ReplaceRegion> regions) {
            this.addReplaceRegions(qualifiedName, null, this.findInsertionOffset(), regions);
        }

        public AliasLocation addSingleImport(QualifiedName qualifiedName, String alias, Collection<ReplaceRegion> regions) {
            return this.addReplaceRegions(qualifiedName, alias, this.findInsertionOffset(), regions);
        }

        public Collection<ReplaceRegion> toReplaceRegions() {
            ArrayList<ReplaceRegion> regions = new ArrayList<ReplaceRegion>();
            this.addReplaceRegions(regions);
            return regions;
        }

        public void addReplaceRegions(Collection<ReplaceRegion> regions) {
            int insertionOffset = this.findInsertionOffset();
            for (NameAndAlias requested : this.requestedImports) {
                this.addReplaceRegions(requested.getName(), requested.getAlias(), insertionOffset, regions);
            }
        }

        private AliasLocation addReplaceRegions(QualifiedName qualifiedName, String optionalAlias, int insertionOffset, Collection<ReplaceRegion> regions) {
            QualifiedName moduleName = qualifiedName.skipLast(1);
            return this.addNewImportDeclaration(moduleName, qualifiedName, optionalAlias, insertionOffset, regions);
        }

        private AliasLocation addNewImportDeclaration(QualifiedName moduleName, QualifiedName qualifiedName, String optionalAlias, int insertionOffset, Collection<ReplaceRegion> replaceRegions) {
            String spacer = (String)this.lazySpacer.get();
            String syntacticModuleName = this.syntacticModuleName(moduleName);
            AliasLocation aliasLocation = null;
            String importSpec = String.valueOf(insertionOffset != 0 ? this.lineDelimiter : "") + "import ";
            if (!N4JSLanguageUtils.isDefaultExport((QualifiedName)qualifiedName)) {
                importSpec = String.valueOf(importSpec) + "{" + spacer + qualifiedName.getLastSegment();
                if (optionalAlias != null) {
                    importSpec = String.valueOf(importSpec) + " as ";
                    aliasLocation = new AliasLocation(insertionOffset, importSpec.length(), optionalAlias);
                    importSpec = String.valueOf(importSpec) + optionalAlias;
                }
                importSpec = String.valueOf(importSpec) + spacer + "}";
            } else if (optionalAlias == null) {
                importSpec = String.valueOf(importSpec) + N4JSLanguageUtils.lastSegmentOrDefaultHost((QualifiedName)qualifiedName);
            } else {
                aliasLocation = new AliasLocation(insertionOffset, importSpec.length(), optionalAlias);
                importSpec = String.valueOf(importSpec) + optionalAlias;
            }
            String insertedCode = String.valueOf(importSpec) + " from " + syntacticModuleName + ";" + (insertionOffset != 0 ? "" : this.lineDelimiter);
            TextRegion region = new TextRegion(insertionOffset, 0);
            replaceRegions.add(new XReplaceRegion((ITextRegion)region, insertedCode));
            return aliasLocation;
        }

        private String syntacticModuleName(QualifiedName moduleName) {
            String syntacticModuleName = ImportRewriter.this.valueConverters.toString((Object)ImportRewriter.this.qualifiedNameConverter.toString(moduleName), ImportRewriter.this.grammarAccess.getModuleSpecifierRule().getName());
            return syntacticModuleName;
        }

        private int findInsertionOffset() {
            int result = 0;
            EList scriptElements = this.script.getScriptElements();
            int i = 0;
            int size = scriptElements.size();
            while (i < size) {
                ScriptElement element = (ScriptElement)scriptElements.get(i);
                if (!(element instanceof ImportDeclaration)) break;
                ICompositeNode importNode = NodeModelUtils.findActualNodeFor((EObject)element);
                if (importNode != null) {
                    result = importNode.getTotalOffset() + this.getLengthWithoutAutomaticSemicolon((INode)importNode);
                }
                ++i;
            }
            if (result != 0) {
                return result;
            }
            return ImportRewriter.this.importsRegionHelper.getImportOffset(this.script);
        }

        private int getLengthWithoutAutomaticSemicolon(INode node) {
            if (node instanceof ILeafNode) {
                return node.getLength();
            }
            int length = 0;
            for (INode leafNode : ((ICompositeNode)node).getLeafNodes()) {
                if (UtilN4.isIgnoredSyntaxErrorNode((INode)leafNode, (String[])new String[]{"InternalSemicolonInjectingParser.ASI"})) continue;
                length += leafNode.getLength();
            }
            return length;
        }
    }
}

