/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.n4js.ide.xtext.server.ExecuteCommandParamsDescriber;
import org.eclipse.n4js.ide.xtext.server.XLanguageServerImpl;
import org.eclipse.xtext.ide.server.commands.ExecutableCommandRegistry;

public class ExecuteCommandParamsTypeAdapter
extends TypeAdapter<ExecuteCommandParams> {
    private static Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private final Gson gson;
    private final Map<String, Type[]> argumentTypes;

    private ExecuteCommandParamsTypeAdapter(Map<String, Type[]> argumentTypes, Gson gson) {
        this.argumentTypes = argumentTypes;
        this.gson = gson;
    }

    public void write(JsonWriter out, ExecuteCommandParams value) throws IOException {
        out.beginObject();
        out.name("command");
        out.value(value.getCommand());
        out.name("arguments");
        out.beginArray();
        for (Object argument : value.getArguments()) {
            this.gson.toJson(argument, argument.getClass(), out);
        }
        out.endArray();
        out.endObject();
    }

    public ExecuteCommandParams read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ExecuteCommandParams result = new ExecuteCommandParams();
        in.beginObject();
        String command = null;
        while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "command": {
                    command = in.nextString();
                    result.setCommand(command);
                    break;
                }
                case "arguments": {
                    result.setArguments(this.parseArguments(in, command));
                    break;
                }
                default: {
                    in.skipValue();
                }
            }
        }
        in.endObject();
        return result;
    }

    private List<Object> parseArguments(JsonReader in, String command) throws IOException, JsonIOException {
        JsonToken next = in.peek();
        if (next == JsonToken.NULL) {
            in.nextNull();
            return Collections.emptyList();
        }
        Type[] argumentTypes = this.getArgumentTypes(command);
        ArrayList<Object> arguments = new ArrayList<Object>(argumentTypes.length);
        int index = 0;
        in.beginArray();
        while (in.hasNext()) {
            Type parameterType = index < argumentTypes.length ? argumentTypes[index] : null;
            Object argument = this.fromJson(in, parameterType);
            arguments.add(argument);
            ++index;
        }
        in.endArray();
        while (index < argumentTypes.length) {
            arguments.add(null);
            ++index;
        }
        return arguments;
    }

    private Object fromJson(JsonReader in, Type type) throws JsonIOException {
        if (this.isNullOrVoidType(type)) {
            return new JsonParser().parse(in);
        }
        return this.gson.fromJson(in, type);
    }

    private boolean isNullOrVoidType(Type type) {
        return type == null || Void.class == type;
    }

    private Type[] getArgumentTypes(String command) {
        return this.argumentTypes.getOrDefault(command, EMPTY_TYPE_ARRAY);
    }

    public static class Factory
    implements TypeAdapterFactory {
        private final XLanguageServerImpl languageServer;

        public Factory(XLanguageServerImpl languageServer) {
            this.languageServer = languageServer;
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!ExecuteCommandParams.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            ExecutableCommandRegistry commandRegistry = this.languageServer.getCommandRegistry();
            Map<String, Type[]> argumentTypes = Collections.emptyMap();
            if (commandRegistry instanceof ExecuteCommandParamsDescriber) {
                argumentTypes = ((ExecuteCommandParamsDescriber)commandRegistry).argumentTypes();
            }
            return new ExecuteCommandParamsTypeAdapter(argumentTypes, gson);
        }
    }
}

