/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.organize.imports;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.organize.imports.ImportProvidedElement;
import org.eclipse.n4js.organize.imports.ImportSpecifiersUtil;
import org.eclipse.n4js.organize.imports.RecordingImportState;
import org.eclipse.n4js.organize.imports.ScriptDependency;
import org.eclipse.n4js.organize.imports.ScriptDependencyResolver;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Log
public class ImportStateCalculator {
    private static final Logger logger = Logger.getLogger(ImportStateCalculator.class);

    public RecordingImportState calculateImportstate(Script script) {
        Pair pM2IPE;
        RecordingImportState reg = new RecordingImportState();
        Iterable importDeclarationsALL = Iterables.filter((Iterable)script.getScriptElements(), ImportDeclaration.class);
        this.registerDuplicatedImoprtDeclarationsFrom(reg, importDeclarationsALL);
        Functions.Function1 _function = it -> {
            boolean _isDuplicatingImportDeclaration = reg.isDuplicatingImportDeclaration((ImportDeclaration)it);
            return !_isDuplicatingImportDeclaration;
        };
        Functions.Function1 _function_1 = it -> it.getImportSpecifiers();
        List importSpecifiersUnAnalyzed = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)importDeclarationsALL, (Functions.Function1)_function), (Functions.Function1)_function_1)));
        this.registerUnusedAndBrokenImports(reg, importSpecifiersUnAnalyzed);
        Functions.Function1 _function_2 = it -> {
            boolean _contains = recordingImportState.brokenImports.contains(it);
            return !_contains;
        };
        List<ImportProvidedElement> importProvidedElements = ImportSpecifiersUtil.mapToImportProvidedElements(IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)importSpecifiersUnAnalyzed, (Functions.Function1)_function_2)));
        ArrayList lN2IPE = CollectionLiterals.newArrayList();
        ArrayList lM2IPE = CollectionLiterals.newArrayList();
        for (ImportProvidedElement ipe : importProvidedElements) {
            Functions.Function1 _function_3 = it -> {
                String _key = (String)it.getKey();
                String _localName = ipe.getLocalName();
                return Objects.equal((Object)_key, (Object)_localName);
            };
            Pair pN2IPE = (Pair)IterableExtensions.findFirst((Iterable)lN2IPE, (Functions.Function1)_function_3);
            if (pN2IPE != null) {
                ((List)pN2IPE.getValue()).add(ipe);
            } else {
                String _localName = ipe.getLocalName();
                ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new ImportProvidedElement[]{ipe});
                Pair _mappedTo = Pair.of((Object)_localName, (Object)_newArrayList);
                lN2IPE.add(_mappedTo);
            }
            Functions.Function1 _function_4 = it -> {
                TModule _key = (TModule)it.getKey();
                TModule _importedModule = ipe.getImportedModule();
                return Objects.equal((Object)_key, (Object)_importedModule);
            };
            pM2IPE = (Pair)IterableExtensions.findFirst((Iterable)lM2IPE, (Functions.Function1)_function_4);
            if (pM2IPE != null) {
                ((List)pM2IPE.getValue()).add(ipe);
                continue;
            }
            TModule _importedModule = ipe.getImportedModule();
            ArrayList _newArrayList_1 = CollectionLiterals.newArrayList((Object[])new ImportProvidedElement[]{ipe});
            Pair _mappedTo_1 = Pair.of((Object)_importedModule, (Object)_newArrayList_1);
            lM2IPE.add(_mappedTo_1);
        }
        this.registerUsedImportsLocalNamesCollisions(reg, lN2IPE);
        this.registerUsedImportsDuplicatedImportedElements(reg, lM2IPE);
        reg.registerAllUsedTypeNameToSpecifierTuples(importProvidedElements);
        List<ScriptDependency> externalDep = ScriptDependencyResolver.usedDependenciesTypeRefs(script);
        for (ScriptDependency scriptDep : externalDep) {
            TModule mod = scriptDep.dependencyModule;
            Functions.Function1 _function_3 = it -> {
                TModule _key = (TModule)it.getKey();
                return Objects.equal((Object)_key, (Object)mod);
            };
            pM2IPE = (Pair)IterableExtensions.findFirst((Iterable)lM2IPE, (Functions.Function1)_function_3);
            if (pM2IPE == null) continue;
            Functions.Function1 _function_4 = it -> Objects.equal((Object)it.getExportedName(), (Object)scriptDependency.actualName) && Objects.equal((Object)it.getLocalName(), (Object)scriptDependency.localName);
            Consumer<ImportProvidedElement> _function_5 = it -> it.markUsed();
            IterableExtensions.filter((Iterable)((Iterable)pM2IPE.getValue()), (Functions.Function1)_function_4).forEach(_function_5);
        }
        return reg;
    }

    private void registerUsedImportsDuplicatedImportedElements(RecordingImportState reg, List<Pair<TModule, List<ImportProvidedElement>>> module2imported) {
        for (Pair<TModule, List<ImportProvidedElement>> pair : module2imported) {
            List fromMod = (List)pair.getValue();
            ArrayListMultimap actname2Import = ArrayListMultimap.create();
            for (ImportProvidedElement ipe : fromMod) {
                actname2Import.put((Object)ipe.getExportedName(), (Object)ipe);
            }
            Set _keySet = actname2Import.keySet();
            for (String act : _keySet) {
                boolean _greaterThan;
                Functions.Function1 _function;
                List v = IterableExtensions.toList((Iterable)actname2Import.get((Object)act));
                List x = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)v, (Functions.Function1)(_function = internalIPE -> {
                    String _computeNamespaceActualName;
                    String _exportedName;
                    boolean _xblockexpression = false;
                    ImportSpecifier specifier = internalIPE.getImportSpecifier();
                    boolean _xifexpression = false;
                    _xifexpression = specifier instanceof NamespaceImportSpecifier ? !Objects.equal((Object)(_exportedName = internalIPE.getExportedName()), (Object)(_computeNamespaceActualName = ImportSpecifiersUtil.computeNamespaceActualName((NamespaceImportSpecifier)specifier))) : true;
                    _xblockexpression = _xifexpression;
                    return _xblockexpression;
                })));
                int _size = x.size();
                boolean bl = _greaterThan = _size > 1;
                if (!_greaterThan) continue;
                reg.registerDuplicateImportsOfSameElement(act, (TModule)pair.getKey(), x);
            }
        }
    }

    private void registerUsedImportsLocalNamesCollisions(RecordingImportState reg, List<Pair<String, List<ImportProvidedElement>>> localname2importprovider) {
        for (Pair<String, List<ImportProvidedElement>> pair : localname2importprovider) {
            boolean _greaterThan;
            int _size = ((List)pair.getValue()).size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            reg.registerLocalNameCollision((String)pair.getKey(), (List)pair.getValue());
        }
    }

    private void registerDuplicatedImoprtDeclarationsFrom(RecordingImportState reg, Iterable<ImportDeclaration> importDeclarations) {
        Functions.Function1 _function = id -> {
            Functions.Function1 _function_1 = is -> is instanceof NamespaceImportSpecifier;
            ImportSpecifier _findFirst = (ImportSpecifier)IterableExtensions.findFirst((Iterable)id.getImportSpecifiers(), (Functions.Function1)_function_1);
            return _findFirst != null;
        };
        Functions.Function1 _function_1 = it -> it.getModule();
        BiConsumer<TModule, List> _function_2 = (module, impDecls) -> this.registerImportDeclarationsWithNamespaceImportsForModule((List<ImportDeclaration>)impDecls, reg);
        IterableExtensions.groupBy((Iterable)IterableExtensions.filter(importDeclarations, (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
        Functions.Function1 _function_3 = id -> {
            Functions.Function1 _function_4 = is -> is instanceof NamedImportSpecifier;
            ImportSpecifier _findFirst = (ImportSpecifier)IterableExtensions.findFirst((Iterable)id.getImportSpecifiers(), (Functions.Function1)_function_4);
            return _findFirst != null;
        };
        Functions.Function1 _function_4 = it -> it.getModule();
        BiConsumer<TModule, List> _function_5 = (module, impDecls) -> this.registerImportDeclarationsWithNamedImportsForModule((List<ImportDeclaration>)impDecls, reg);
        IterableExtensions.groupBy((Iterable)IterableExtensions.filter(importDeclarations, (Functions.Function1)_function_3), (Functions.Function1)_function_4).forEach(_function_5);
    }

    private void registerImportDeclarationsWithNamespaceImportsForModule(List<ImportDeclaration> importDeclarations, RecordingImportState reg) {
        boolean _not;
        boolean _lessThan;
        int _size = importDeclarations.size();
        boolean bl = _lessThan = _size < 2;
        if (_lessThan) {
            return;
        }
        ArrayList duplicates = CollectionLiterals.newArrayList();
        ImportDeclaration firstDeclaration = (ImportDeclaration)IterableExtensions.head(importDeclarations);
        String firstNamespaceName = ((NamespaceImportSpecifier)IterableExtensions.head((Iterable)Iterables.filter((Iterable)firstDeclaration.getImportSpecifiers(), NamespaceImportSpecifier.class))).getAlias();
        Consumer<ImportDeclaration> _function = importDeclaration -> {
            String followingNamespaceName = ((NamespaceImportSpecifier)IterableExtensions.head((Iterable)Iterables.filter((Iterable)importDeclaration.getImportSpecifiers(), NamespaceImportSpecifier.class))).getAlias();
            boolean _equals = Objects.equal((Object)firstNamespaceName, (Object)followingNamespaceName);
            if (_equals) {
                duplicates.add(importDeclaration);
            }
        };
        IterableExtensions.tail(importDeclarations).forEach(_function);
        boolean _isEmpty = duplicates.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            reg.registerDuplicatesOfImportDeclaration(firstDeclaration, duplicates);
        }
    }

    private void registerImportDeclarationsWithNamedImportsForModule(List<ImportDeclaration> importDeclarations, RecordingImportState reg) {
        boolean _not;
        boolean _lessThan;
        int _size = importDeclarations.size();
        boolean bl = _lessThan = _size < 2;
        if (_lessThan) {
            return;
        }
        ArrayList duplicates = CollectionLiterals.newArrayList();
        ImportDeclaration firstDeclaration = (ImportDeclaration)IterableExtensions.head(importDeclarations);
        Iterable firstDeclarationSpecifiers = Iterables.filter((Iterable)firstDeclaration.getImportSpecifiers(), NamedImportSpecifier.class);
        Consumer<ImportDeclaration> _function = importDeclaration -> {
            boolean _allFollowingMatchByNameAndAlias;
            Iterable followingDeclarationSpecifiers = Iterables.filter((Iterable)importDeclaration.getImportSpecifiers(), NamedImportSpecifier.class);
            if (!IterableExtensions.isEmpty((Iterable)firstDeclarationSpecifiers) && IterableExtensions.size((Iterable)firstDeclarationSpecifiers) == IterableExtensions.size((Iterable)followingDeclarationSpecifiers) && (_allFollowingMatchByNameAndAlias = this.allFollowingMatchByNameAndAlias(firstDeclarationSpecifiers, followingDeclarationSpecifiers))) {
                duplicates.add(importDeclaration);
            }
        };
        IterableExtensions.tail(importDeclarations).forEach(_function);
        boolean _isEmpty = duplicates.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            reg.registerDuplicatesOfImportDeclaration(firstDeclaration, duplicates);
        }
    }

    private boolean allFollowingMatchByNameAndAlias(Iterable<NamedImportSpecifier> firstDeclarationSpecifiers, Iterable<NamedImportSpecifier> followingDeclarationSpecifiers) {
        Functions.Function1 _function = namedImportSpecifier -> {
            Functions.Function1 _function_1 = otherNamedImportSpecifier -> Objects.equal((Object)namedImportSpecifier.getAlias(), (Object)otherNamedImportSpecifier.getAlias()) && Objects.equal((Object)namedImportSpecifier.getImportedElement().getName(), (Object)otherNamedImportSpecifier.getImportedElement().getName());
            return IterableExtensions.exists((Iterable)followingDeclarationSpecifiers, (Functions.Function1)_function_1);
        };
        return IterableExtensions.forall(firstDeclarationSpecifiers, (Functions.Function1)_function);
    }

    private void registerUnusedAndBrokenImports(RecordingImportState reg, List<ImportSpecifier> importSpecifiers) {
        for (ImportSpecifier is : importSpecifiers) {
            boolean _not;
            boolean _isFlaggedUsedInCode = is.isFlaggedUsedInCode();
            boolean bl = _not = !_isFlaggedUsedInCode;
            if (!_not) continue;
            reg.registerUnusedImport(is);
            boolean _isBrokenImport = ImportSpecifiersUtil.isBrokenImport(is);
            if (!_isBrokenImport) continue;
            reg.registerBrokenImport(is);
        }
    }
}

