/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.imports;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.n4js.ide.server.codeActions.util.ChangeProvider;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.organize.imports.ImportSpecifiersUtil;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.nodemodel.NodeModelUtilsN4;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;

public class ImportOrganizer {
    public static List<TextEdit> organizeImports(Document document, Script script, CancelIndicator cancelIndicator) {
        ((N4JSResource)script.eResource()).performPostProcessing(cancelIndicator);
        List<ImportDeclaration> importDecls = script.getScriptElements().stream().filter(ImportDeclaration.class::isInstance).map(ImportDeclaration.class::cast).collect(Collectors.toList());
        SortedSet<ImportRef> importRefs = ImportOrganizer.createImportRefs(importDecls);
        ArrayList<TextEdit> textEdits = new ArrayList();
        int offsetOfFirstImport = Integer.MAX_VALUE;
        for (ImportDeclaration importDecl : importDecls) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)importDecl);
            int offset = node.getOffset();
            int length = NodeModelUtilsN4.getNodeLengthWithASISupport((INode)node);
            TextEdit edit = ChangeProvider.removeText(document, offset, length, true);
            textEdits.add(edit);
            offsetOfFirstImport = Math.min(offsetOfFirstImport, node.getOffset());
        }
        textEdits = ChangeProvider.closeGapsIfEmpty(document, textEdits);
        String[] importStrings = (String[])importRefs.stream().map(ImportRef::toCode).toArray(String[]::new);
        if (importStrings.length > 0) {
            TextEdit edit = ChangeProvider.insertLinesAbove(document, offsetOfFirstImport, false, importStrings);
            textEdits.add(edit);
        }
        return textEdits;
    }

    private static SortedSet<ImportRef> createImportRefs(List<ImportDeclaration> importDecls) {
        TreeSet<ImportRef> result = new TreeSet<ImportRef>();
        int idx = 0;
        for (ImportDeclaration importDecl : importDecls) {
            if (importDecl.isBare()) {
                if (ImportSpecifiersUtil.isBrokenImport((ImportDeclaration)importDecl)) continue;
                result.add(new ImportRef(importDecl, null, idx++));
                continue;
            }
            for (ImportSpecifier importSpec : importDecl.getImportSpecifiers()) {
                if (!importSpec.isFlaggedUsedInCode() || ImportSpecifiersUtil.isBrokenImport((ImportSpecifier)importSpec)) continue;
                result.add(new ImportRef(importDecl, importSpec, idx++));
            }
        }
        return result;
    }

    private static class ImportRef
    implements Comparable<ImportRef> {
        final ImportDeclaration importDecl;
        final ImportSpecifier importSpec;
        final int originalIndex;

        ImportRef(ImportDeclaration importDecl, ImportSpecifier importSpec, int originalIndex) {
            this.importDecl = importDecl;
            this.importSpec = importSpec;
            this.originalIndex = originalIndex;
            if (importDecl.isBare() != (importSpec == null)) {
                throw new IllegalArgumentException("importSpec must be null if and only if importDecl is a bare import");
            }
            if (importSpec != null && !importSpec.isFlaggedUsedInCode()) {
                throw new IllegalArgumentException("must not create an ImportRef for unused imports");
            }
            if (importSpec == null && ImportSpecifiersUtil.isBrokenImport((ImportDeclaration)importDecl) || importSpec != null && ImportSpecifiersUtil.isBrokenImport((ImportSpecifier)importSpec)) {
                throw new IllegalArgumentException("must not create an ImportRef for broken imports");
            }
        }

        public boolean isBare() {
            return this.importDecl.isBare();
        }

        public int hashCode() {
            if (this.importSpec == null) {
                return this.importDecl.getModule().hashCode();
            }
            if (this.importSpec instanceof NamedImportSpecifier) {
                return Objects.hash(Boolean.FALSE, this.importDecl.getModule(), ((NamedImportSpecifier)this.importSpec).isDefaultImport(), ((NamedImportSpecifier)this.importSpec).getImportedElement(), ((NamedImportSpecifier)this.importSpec).getAlias());
            }
            if (this.importSpec instanceof NamespaceImportSpecifier) {
                return Objects.hash(Boolean.TRUE, this.importDecl.getModule(), ((NamespaceImportSpecifier)this.importSpec).getAlias());
            }
            throw new IllegalStateException("unknown subclass of ImportSpecifier: " + this.importSpec.getClass().getSimpleName());
        }

        public boolean equals(Object other) {
            if (!(other instanceof ImportRef)) {
                return false;
            }
            return this.compareTo((ImportRef)other) == 0;
        }

        @Override
        public int compareTo(ImportRef other) {
            boolean isOtherDefault;
            int cmpBareness = Boolean.compare(this.isBare(), other.isBare()) * -1;
            if (cmpBareness != 0) {
                return cmpBareness;
            }
            if (this.isBare()) {
                if (this.importDecl.getModule() == other.importDecl.getModule()) {
                    return 0;
                }
                return Integer.compare(this.originalIndex, other.originalIndex);
            }
            int cmpModule = this.getFQN(this.importDecl.getModule()).compareTo(this.getFQN(other.importDecl.getModule()));
            if (cmpModule != 0) {
                return cmpModule;
            }
            boolean isThisNamespace = this.importSpec instanceof NamespaceImportSpecifier;
            boolean isOtherNamespace = other.importSpec instanceof NamespaceImportSpecifier;
            int cmpNamespace = Boolean.compare(isThisNamespace, isOtherNamespace) * -1;
            if (cmpNamespace != 0) {
                return cmpNamespace;
            }
            if (isThisNamespace && isOtherNamespace) {
                return ((NamespaceImportSpecifier)this.importSpec).getAlias().compareTo(((NamespaceImportSpecifier)other.importSpec).getAlias());
            }
            boolean isThisDefault = ((NamedImportSpecifier)this.importSpec).isDefaultImport();
            int cmpDefault = Boolean.compare(isThisDefault, isOtherDefault = ((NamedImportSpecifier)other.importSpec).isDefaultImport()) * -1;
            if (cmpDefault != 0) {
                return cmpDefault;
            }
            int cmpName = ((NamedImportSpecifier)this.importSpec).getImportedElementAsText().compareTo(((NamedImportSpecifier)other.importSpec).getImportedElementAsText());
            if (cmpName != 0) {
                return cmpName;
            }
            String thisAlias = ((NamedImportSpecifier)this.importSpec).getAlias();
            String otherAlias = ((NamedImportSpecifier)other.importSpec).getAlias();
            int cmpAlias = thisAlias != null && otherAlias != null ? thisAlias.compareTo(otherAlias) : Boolean.compare(thisAlias != null, otherAlias != null);
            return cmpAlias;
        }

        private String getFQN(TModule module) {
            return String.valueOf(module.getProjectName()) + "/" + module.getQualifiedName();
        }

        public String toCode() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("import ");
            if (this.importSpec instanceof NamedImportSpecifier) {
                NamedImportSpecifier importSpecCasted = (NamedImportSpecifier)this.importSpec;
                if (importSpecCasted.isDefaultImport()) {
                    sb.append(importSpecCasted.getAlias());
                } else {
                    sb.append('{');
                    sb.append(importSpecCasted.getImportedElementAsText());
                    String alias = importSpecCasted.getAlias();
                    if (alias != null) {
                        sb.append(" as ");
                        sb.append(alias);
                    }
                    sb.append('}');
                }
                sb.append(' ');
            } else if (this.importSpec instanceof NamespaceImportSpecifier) {
                sb.append("* as ");
                sb.append(((NamespaceImportSpecifier)this.importSpec).getAlias());
                sb.append(' ');
            }
            if (!this.isBare()) {
                sb.append("from ");
            }
            sb.append('\"');
            sb.append(this.importDecl.getModuleSpecifierAsText());
            sb.append('\"');
            sb.append(';');
            return sb.toString();
        }
    }
}

