/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.PlatformResourceURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.ui.internal.EclipseBasedN4JSWorkspace;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class ExternalProjectMappings {
    public static boolean REDUCE_REGISTERED_NPMS = true;
    private final EclipseBasedN4JSWorkspace userWorkspace;
    private final ExternalLibraryPreferenceStore preferenceStore;
    final Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> completeCache;
    final List<Pair<FileURI, ProjectDescription>> completeList;
    final Map<N4JSProjectName, List<N4JSExternalProject>> completeProjectNameMapping;
    final Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> reducedProjectUriMapping;
    final Map<FileURI, List<N4JSExternalProject>> reducedProjectsLocationMapping;
    final Set<N4JSExternalProject> reducedSet;
    final boolean initialized;

    ExternalProjectMappings(EclipseBasedN4JSWorkspace userWorkspace, ExternalLibraryPreferenceStore preferenceStore, Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> completeCache) {
        this(userWorkspace, preferenceStore, completeCache, true);
    }

    protected ExternalProjectMappings(EclipseBasedN4JSWorkspace userWorkspace, ExternalLibraryPreferenceStore preferenceStore, Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> completeCache, boolean initialized) {
        this.userWorkspace = userWorkspace;
        this.preferenceStore = preferenceStore;
        this.completeCache = completeCache != null ? new LinkedHashMap<FileURI, Pair<N4JSExternalProject, ProjectDescription>>(completeCache) : Collections.emptyMap();
        this.removeDuplicatesFromCompleteCache();
        Mappings mappings = this.computeMappings();
        this.completeList = mappings.completeList;
        this.completeProjectNameMapping = mappings.completeProjectNameMapping;
        this.reducedProjectUriMapping = mappings.reducedProjectUriMapping;
        this.reducedProjectsLocationMapping = mappings.reducedProjectsLocationMapping;
        this.reducedSet = mappings.reducedSet;
        this.initialized = initialized;
    }

    private void removeDuplicatesFromCompleteCache() {
        if (this.completeCache.isEmpty()) {
            return;
        }
        HashSet<PlatformResourceURI> locationsOfWorkspaceProjects = new HashSet<PlatformResourceURI>(this.userWorkspace.getAllProjectLocations());
        HashMap<N4JSProjectName, FileURI> workspaceAsFileURIs = new HashMap<N4JSProjectName, FileURI>();
        for (PlatformResourceURI wsProject : locationsOfWorkspaceProjects) {
            workspaceAsFileURIs.put(wsProject.getProjectName(), wsProject.toFileURI());
        }
        LinkedList<FileURI> allPrjLocs = new LinkedList<FileURI>(this.completeCache.keySet());
        for (FileURI projectLocation : allPrjLocs) {
            FileURI fromWorkspace = (FileURI)workspaceAsFileURIs.get(projectLocation.getProjectName());
            if (fromWorkspace == null) continue;
            if (projectLocation.equals((Object)fromWorkspace)) {
                this.completeCache.remove(projectLocation);
                continue;
            }
            try {
                FileURI canonicalLocation = projectLocation.resolveSymLinks();
                if (!canonicalLocation.equals((Object)fromWorkspace)) continue;
                this.completeCache.remove(projectLocation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Mappings computeMappings() {
        HashMap completeProjectNameMappingTmp = Maps.newHashMap();
        HashMap reducedProjectUriMappingTmp = Maps.newHashMap();
        HashMap reducedProjectsLocationMappingTmp = Maps.newHashMap();
        LinkedList<Pair> completeListTmp = new LinkedList<Pair>();
        if (this.completeCache.isEmpty()) {
            Mappings mappings = new Mappings();
            mappings.completeList = Collections.emptyList();
            mappings.completeProjectNameMapping = Collections.emptyMap();
            mappings.reducedSet = Collections.emptySet();
            mappings.reducedProjectsLocationMapping = Collections.emptyMap();
            mappings.reducedProjectUriMapping = Collections.emptyMap();
            return mappings;
        }
        LinkedList<FileURI> allPrjLocsReversed = new LinkedList<FileURI>(this.completeCache.keySet());
        for (FileURI projectLocation : allPrjLocsReversed) {
            Pair<N4JSExternalProject, ProjectDescription> pair = this.completeCache.get(projectLocation);
            N4JSExternalProject project = (N4JSExternalProject)pair.getFirst();
            ProjectDescription prjDescr = (ProjectDescription)pair.getSecond();
            completeListTmp.add(Tuples.pair((Object)projectLocation, (Object)prjDescr));
            N4JSProjectName projectName = projectLocation.getProjectName();
            if (!completeProjectNameMappingTmp.containsKey(projectName)) {
                completeProjectNameMappingTmp.put(projectName, Lists.newArrayList((Object[])new N4JSExternalProject[]{project}));
                reducedProjectUriMappingTmp.put(projectLocation, pair);
                FileURI rootLoc = ExternalLibraryWorkspace.getRootLocationForResource((Collection)this.preferenceStore.getLocations(), (SafeURI)projectLocation);
                reducedProjectsLocationMappingTmp.putIfAbsent(rootLoc, new LinkedList());
                ((List)reducedProjectsLocationMappingTmp.get(rootLoc)).add(project);
                continue;
            }
            List list = (List)completeProjectNameMappingTmp.get(projectName);
            list.add(project);
        }
        Set<SafeURI<?>> reducedSetURIs = this.computeUserWorkspaceDependencies(completeProjectNameMappingTmp, reducedProjectUriMappingTmp);
        HashSet<N4JSExternalProject> reducedSetTmps = new HashSet<N4JSExternalProject>();
        for (SafeURI<?> prjLoc : reducedSetURIs) {
            Pair pair = (Pair)reducedProjectUriMappingTmp.get(prjLoc);
            if (pair == null) continue;
            N4JSExternalProject project = (N4JSExternalProject)pair.getFirst();
            reducedSetTmps.add(project);
        }
        if (REDUCE_REGISTERED_NPMS) {
            for (FileURI nodeModuleLocation : this.preferenceStore.getNodeModulesLocations()) {
                List nodeModuleProjects = (List)reducedProjectsLocationMappingTmp.get(nodeModuleLocation);
                if (nodeModuleProjects == null) continue;
                Iterator iter = nodeModuleProjects.iterator();
                while (iter.hasNext()) {
                    FileURI location = ((N4JSExternalProject)iter.next()).getSafeLocation();
                    if (reducedSetURIs.contains(location)) continue;
                    iter.remove();
                }
            }
            reducedProjectUriMappingTmp.keySet().retainAll(reducedSetURIs);
            Preconditions.checkState((reducedSetURIs.size() == reducedProjectUriMappingTmp.size() ? 1 : 0) != 0);
        } else {
            for (List rlPrjs : reducedProjectsLocationMappingTmp.values()) {
                reducedSetTmps.addAll(rlPrjs);
            }
        }
        Mappings mappings = new Mappings();
        mappings.completeList = Collections.unmodifiableList(completeListTmp);
        mappings.completeProjectNameMapping = Collections.unmodifiableMap(completeProjectNameMappingTmp);
        mappings.reducedSet = Collections.unmodifiableSet(reducedSetTmps);
        mappings.reducedProjectsLocationMapping = Collections.unmodifiableMap(reducedProjectsLocationMappingTmp);
        mappings.reducedProjectUriMapping = Collections.unmodifiableMap(reducedProjectUriMappingTmp);
        return mappings;
    }

    Set<SafeURI<?>> computeUserWorkspaceDependencies(Map<N4JSProjectName, List<N4JSExternalProject>> completeProjectNameMappingTmp, Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> reducedProjectUriMappingTmp) {
        HashSet uwsDeps = new HashSet();
        LinkedList projectsInUserWSopen = new LinkedList();
        for (PlatformResourceURI projectInUserWS : this.userWorkspace.getAllProjectLocations()) {
            projectsInUserWSopen.add((SafeURI<?>)projectInUserWS);
        }
        this.computeNecessaryDependenciesRek(completeProjectNameMappingTmp, reducedProjectUriMappingTmp, projectsInUserWSopen, uwsDeps);
        uwsDeps.removeAll(projectsInUserWSopen);
        return uwsDeps;
    }

    private void computeNecessaryDependenciesRek(Map<N4JSProjectName, List<N4JSExternalProject>> projectNameMappingTmp, Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> projectUriMappingTmp, Collection<SafeURI<?>> locs, Set<SafeURI<?>> necessaryDeps) {
        HashSet depUris = new HashSet();
        for (SafeURI<?> loc : locs) {
            ProjectDescription pd = this.getProjectDescription(projectUriMappingTmp, loc);
            if (pd == null || pd.getProjectType() == ProjectType.PLAINJS) continue;
            for (ProjectDependency pDep : pd.getProjectDependencies()) {
                SafeURI<?> depLoc = this.getProjectLocation(projectNameMappingTmp, pDep);
                if (depLoc == null || necessaryDeps.contains(depLoc)) continue;
                depUris.add(depLoc);
                necessaryDeps.add(depLoc);
            }
        }
        if (!depUris.isEmpty()) {
            this.computeNecessaryDependenciesRek(projectNameMappingTmp, projectUriMappingTmp, depUris, necessaryDeps);
        }
    }

    private SafeURI<?> getProjectLocation(Map<N4JSProjectName, List<N4JSExternalProject>> projectNameMappingTmp, ProjectDependency pDep) {
        N4JSProjectName projectName = new N4JSProjectName(pDep.getProjectName());
        PlatformResourceURI depLoc = this.userWorkspace.getProjectLocation(projectName);
        if (depLoc == null) {
            N4JSExternalProject project;
            List<N4JSExternalProject> prjsOfName = projectNameMappingTmp.get(projectName);
            N4JSExternalProject n4JSExternalProject = project = prjsOfName == null || prjsOfName.isEmpty() ? null : prjsOfName.get(0);
            if (project != null) {
                depLoc = project.getSafeLocation();
            }
        }
        return depLoc;
    }

    private ProjectDescription getProjectDescription(Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> projectUriMappingTmp, SafeURI<?> loc) {
        Pair<N4JSExternalProject, ProjectDescription> pair;
        ProjectDescription pd;
        ProjectDescription projectDescription = pd = loc instanceof PlatformResourceURI ? this.userWorkspace.getProjectDescription((PlatformResourceURI)loc) : null;
        if (pd == null && (pair = projectUriMappingTmp.get(loc)) != null) {
            pd = (ProjectDescription)pair.getSecond();
        }
        return pd;
    }

    private static class Mappings {
        List<Pair<FileURI, ProjectDescription>> completeList;
        Map<N4JSProjectName, List<N4JSExternalProject>> completeProjectNameMapping;
        Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> reducedProjectUriMapping;
        Map<FileURI, List<N4JSExternalProject>> reducedProjectsLocationMapping;
        Set<N4JSExternalProject> reducedSet;

        private Mappings() {
        }
    }
}

