/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.print;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.transpiler.AbstractTranspiler;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.im.Script_IM;
import org.eclipse.n4js.transpiler.print.PositionProvider;
import org.eclipse.n4js.transpiler.print.PrettyPrinterSwitch;
import org.eclipse.n4js.transpiler.print.SourceMapAwareAppendable;
import org.eclipse.n4js.transpiler.sourcemap.FilePosition;
import org.eclipse.n4js.transpiler.sourcemap.SourceMapRev3Generator;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegion;

public class PrettyPrinter {
    private static final String INDENT = "\t";
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    public void print(TranspilerState state, Writer outCode, Optional<String> optPreamble, Optional<AbstractTranspiler.SourceMapInfo> optSourceMapInfo) throws IOException {
        boolean emitSourceMaps = optSourceMapInfo.isPresent();
        SourceMapAwareAppendable out = new SourceMapAwareAppendable(outCode, INDENT, emitSourceMaps);
        if (optPreamble.isPresent()) {
            out.append((CharSequence)optPreamble.get());
            out.newLine();
        }
        PrettyPrinterSwitch.append(out, state);
        if (emitSourceMaps) {
            AbstractTranspiler.SourceMapInfo sourceMapInfo = (AbstractTranspiler.SourceMapInfo)optSourceMapInfo.get();
            SourceMapRev3Generator generator = new SourceMapRev3Generator();
            out.newLine();
            out.append("//# sourceMappingURL=" + sourceMapInfo.simpleSourceMapFileName);
            out.newLine();
            ArrayList<SourceMapAwareAppendable.SourceOutputMapping> mappings = new ArrayList<SourceMapAwareAppendable.SourceOutputMapping>(out.getSourceMapData());
            this.removeCatchAllMapping(mappings);
            PositionProvider positionProvider = PositionProvider.from(state.resource);
            for (SourceMapAwareAppendable.SourceOutputMapping m : mappings) {
                EObject originalASTNode = state.tracer.getOriginalASTNode(m.elementInIM);
                if (originalASTNode == null || !(originalASTNode.eResource() instanceof N4JSResource)) continue;
                ITextRegion region = this.locationInFileProvider.getSignificantTextRegion(originalASTNode);
                String path = sourceMapInfo.resolve((N4JSResource)originalASTNode.eResource());
                FilePosition sourceStartPosition = positionProvider.toPosition(region.getOffset());
                generator.addMapping(path, null, sourceStartPosition, m.outputStart, m.outputEnd);
            }
            generator.appendTo(sourceMapInfo.sourceMapBuff, sourceMapInfo.simpleCompiledFileName);
        }
    }

    private void removeCatchAllMapping(List<SourceMapAwareAppendable.SourceOutputMapping> mappings) {
        int lastIdx = mappings.size() - 1;
        if (!(mappings.get((int)lastIdx).elementInIM instanceof Script_IM)) {
            throw new IllegalStateException("did not find the expected mapping for the Script_IM element");
        }
        mappings.remove(lastIdx);
    }
}

