/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.sourcemap;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.n4js.transpiler.sourcemap.FilePosition;
import org.eclipse.n4js.transpiler.sourcemap.MappingEntry;
import org.eclipse.n4js.transpiler.sourcemap.SourceMap;
import org.eclipse.n4js.transpiler.sourcemap.SourceMapGenerator;

public class SourceMapRev3Generator
implements SourceMapGenerator {
    Map<String, Integer> sources = new LinkedHashMap<String, Integer>();
    Map<String, Integer> names = new LinkedHashMap<String, Integer>();
    SourceMap map = new SourceMap();

    @Override
    public void reset() {
        this.sources.clear();
        this.names.clear();
        this.map = new SourceMap();
    }

    @Override
    public void addMapping(String srcName, String symbolName, FilePosition srcStartPos, FilePosition outStartPos, FilePosition outEndPos) {
        if (srcName == null) {
            this.map.addMappig(new MappingEntry(outStartPos));
        } else {
            int sourceIndex = this.getOrCreateSourceIndex(srcName);
            int nameIndex = symbolName != null ? this.getOrCreateNameIndex(symbolName) : -1;
            this.map.addMappig(new MappingEntry(outStartPos, sourceIndex, srcStartPos, nameIndex));
        }
    }

    private int getOrCreateNameIndex(String symbolName) {
        Integer index = this.names.get(symbolName);
        if (index == null) {
            index = this.names.size();
            this.names.put(symbolName, index);
        }
        return index;
    }

    private int getOrCreateSourceIndex(String sourceName) {
        Integer index = this.sources.get(sourceName);
        if (index == null) {
            index = this.sources.size();
            this.sources.put(sourceName, index);
        }
        return index;
    }

    @Override
    public void appendTo(Appendable out, String fileName) throws IOException {
        this.map.file = fileName;
        this.map.sources.addAll(this.sources.keySet());
        this.map.names.addAll(this.names.keySet());
        this.map.toString(out);
    }
}

