/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.AbstractCaseClause;
import org.eclipse.n4js.n4JS.CaseClause;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Statement;

class AbstractCaseClauseFactory {
    AbstractCaseClauseFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, AbstractCaseClause abstrCaseClause) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)abstrCaseClause);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)abstrCaseClause);
        LinkedList<DelegatingNode> stmtNodes = new LinkedList<DelegatingNode>();
        DelegatingNode caseConditionNode = null;
        if (abstrCaseClause instanceof CaseClause) {
            CaseClause caseClause = (CaseClause)abstrCaseClause;
            caseConditionNode = DelegatingNodeFactory.create(astpp, "condition", (ControlFlowElement)caseClause, (ControlFlowElement)caseClause.getExpression());
        }
        EList stmts = abstrCaseClause.getStatements();
        int i = 0;
        while (i < stmts.size()) {
            Statement statement = (Statement)stmts.get(i);
            DelegatingNode blockNode = new DelegatingNode("stmt_" + i, astpp.pos(), (ControlFlowElement)abstrCaseClause, (ControlFlowElement)statement);
            stmtNodes.add(blockNode);
            astpp.visitUtil(((Node)blockNode).getDelegatedControlFlowElement());
            ++i;
        }
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)abstrCaseClause);
        cNode.addNode(entryNode);
        cNode.addNode(caseConditionNode);
        for (Node node : stmtNodes) {
            cNode.addNode(node);
        }
        cNode.addNode(exitNode);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(entryNode);
        linkedList.add(caseConditionNode);
        linkedList.addAll(stmtNodes);
        linkedList.add(exitNode);
        cNode.connectInternalSucc(linkedList);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        return cNode;
    }
}

