/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.formatting2;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JSONFormatter
extends AbstractFormatter2 {
    protected void _format(JSONDocument jSONDocument, @Extension IFormattableDocument document) {
        document.format((Object)jSONDocument.getContent());
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.indent();
            document.append(it, _function_1);
        };
        this.textRegionExtensions.allSemanticRegions((EObject)jSONDocument).forEach(_function);
    }

    protected void _format(JSONArray al, @Extension IFormattableDocument document) {
        this.configureCommas((EObject)al, document);
        Pair bracketPair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)al).keywordPairs("[", "]"));
        if (bracketPair != null) {
            Procedures.Procedure1 _function = it -> it.indent();
            document.interior(bracketPair, _function);
            boolean _isEmpty = al.getElements().isEmpty();
            if (_isEmpty) {
                Procedures.Procedure1 _function_1 = it -> it.noSpace();
                document.append((ISemanticRegion)bracketPair.getKey(), _function_1);
                Procedures.Procedure1 _function_2 = it -> it.noSpace();
                document.prepend((ISemanticRegion)bracketPair.getValue(), _function_2);
                return;
            }
            Procedures.Procedure1 _function_3 = it -> it.newLine();
            document.prepend((ISemanticRegion)bracketPair.getValue(), _function_3);
        }
        Procedures.Procedure2 _function_4 = (it, num) -> {
            Procedures.Procedure1 _function_5 = it_1 -> it_1.newLine();
            document.prepend((EObject)it, _function_5);
        };
        IterableExtensions.forEach((Iterable)al.getElements(), (Procedures.Procedure2)_function_4);
        Consumer<JSONValue> _function_5 = it -> document.format(it);
        al.getElements().forEach(_function_5);
    }

    private void configureCommas(EObject semEObject, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
            document.prepend(it, _function_1);
            Procedures.Procedure1 _function_2 = it_1 -> {
                it_1.oneSpace();
                it_1.autowrap();
            };
            document.append(it, _function_2);
        };
        this.textRegionExtensions.regionFor(semEObject).keywords(new String[]{","}).forEach(_function);
    }

    protected void _format(JSONObject ol, @Extension IFormattableDocument document) {
        this.configureCommas((EObject)ol, document);
        Pair bracePair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)ol).keywordPairs("{", "}"));
        if (bracePair != null) {
            boolean _equals;
            boolean _isEmpty;
            if (bracePair != null) {
                Procedures.Procedure1 _function = it -> it.indent();
                document.interior(bracePair, _function);
            }
            if (_isEmpty = ol.getNameValuePairs().isEmpty()) {
                Procedures.Procedure1 _function_1 = it -> it.noSpace();
                document.append((ISemanticRegion)bracePair.getKey(), _function_1);
                Procedures.Procedure1 _function_2 = it -> it.noSpace();
                document.prepend((ISemanticRegion)bracePair.getValue(), _function_2);
                return;
            }
            ISemanticRegion _value = null;
            if (bracePair != null) {
                _value = (ISemanticRegion)bracePair.getValue();
            }
            Procedures.Procedure1 _function_3 = it -> it.newLine();
            document.prepend(_value, _function_3);
            Procedures.Procedure2 _function_4 = (it, num) -> {
                Procedures.Procedure1 _function_5 = it_1 -> it_1.newLine();
                document.prepend((EObject)it, _function_5);
            };
            IterableExtensions.forEach((Iterable)ol.getNameValuePairs(), (Procedures.Procedure2)_function_4);
            ISemanticRegion _key = null;
            if (bracePair != null) {
                _key = (ISemanticRegion)bracePair.getKey();
            }
            ISemanticRegion _nextSemanticRegion = null;
            if (_key != null) {
                _nextSemanticRegion = _key.getNextSemanticRegion();
            }
            ISemanticRegion _value_1 = null;
            if (bracePair != null) {
                _value_1 = (ISemanticRegion)bracePair.getValue();
            }
            if (_equals = Objects.equal((Object)_nextSemanticRegion, _value_1)) {
                Procedures.Procedure1 _function_5 = it -> it.newLine();
                document.append((ISemanticRegion)bracePair.getKey(), _function_5);
            }
        }
        Consumer<NameValuePair> _function_6 = it -> document.format(it);
        ol.getNameValuePairs().forEach(_function_6);
    }

    protected void _format(NameValuePair nameValuePair, @Extension IFormattableDocument document) {
        ISemanticRegion colon = this.textRegionExtensions.regionFor((EObject)nameValuePair).keyword(":");
        JSONValue value = nameValuePair.getValue();
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(colon, _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(colon, _function_1);
        document.format((Object)value);
    }

    public void format(Object al, IFormattableDocument document) {
        if (al instanceof XtextResource) {
            this._format((XtextResource)al, document);
            return;
        }
        if (al instanceof JSONArray) {
            this._format((JSONArray)al, document);
            return;
        }
        if (al instanceof JSONObject) {
            this._format((JSONObject)al, document);
            return;
        }
        if (al instanceof JSONDocument) {
            this._format((JSONDocument)al, document);
            return;
        }
        if (al instanceof NameValuePair) {
            this._format((NameValuePair)al, document);
            return;
        }
        if (al instanceof EObject) {
            this._format((EObject)al, document);
            return;
        }
        if (al == null) {
            this._format(null, document);
            return;
        }
        if (al != null) {
            this._format(al, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(al, document).toString());
    }
}

