/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressInfoItem;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class DetailedProgressViewer
extends AbstractProgressViewer {
    private int maxDisplayed;
    Composite control;
    private ScrolledComposite scrolled;
    private Composite noEntryArea;

    public DetailedProgressViewer(Composite parent, int style) {
        this.scrolled = new ScrolledComposite(parent, 0x200 | style);
        int height = JFaceResources.getDefaultFont().getFontData()[0].getHeight();
        this.scrolled.getVerticalBar().setIncrement(height * 2);
        this.scrolled.setExpandHorizontal(true);
        this.scrolled.setExpandVertical(true);
        this.control = new Composite((Composite)this.scrolled, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.control.setLayout((Layout)layout);
        this.control.setBackground(parent.getDisplay().getSystemColor(25));
        this.control.addFocusListener((FocusListener)new FocusAdapter(){
            private boolean settingFocus = false;

            public void focusGained(FocusEvent e) {
                if (!this.settingFocus) {
                    this.settingFocus = true;
                    DetailedProgressViewer.this.setFocus();
                    this.settingFocus = false;
                }
            }
        });
        this.control.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                DetailedProgressViewer.this.updateVisibleItems();
            }

            public void controlResized(ControlEvent e) {
                DetailedProgressViewer.this.updateVisibleItems();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.control, "org.eclipse.ui.responsive_ui_context");
        this.scrolled.setContent((Control)this.control);
        this.hookControl((Control)this.control);
        this.noEntryArea = new Composite((Composite)this.scrolled, 0);
        this.noEntryArea.setLayout((Layout)new GridLayout());
        this.noEntryArea.setBackground(this.noEntryArea.getDisplay().getSystemColor(25));
        Label noEntryLabel = new Label(this.noEntryArea, 0);
        noEntryLabel.setText(ProgressMessages.ProgressView_NoOperations);
        noEntryLabel.setBackground(this.noEntryArea.getDisplay().getSystemColor(25));
        GridData textData = new GridData(2);
        noEntryLabel.setLayoutData((Object)textData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)noEntryLabel, "org.eclipse.ui.responsive_ui_context");
        IPreferenceStore prefs = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.updateMaxDisplayedValue(prefs);
        IPropertyChangeListener listener = x -> this.propertyChange(x);
        prefs.addPropertyChangeListener(listener);
        this.scrolled.addDisposeListener(x -> prefs.removePropertyChangeListener(listener));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!"MAX_PROGRESS_ENTRIES".equals(event.getProperty())) {
            return;
        }
        this.updateMaxDisplayedValue(WorkbenchPlugin.getDefault().getPreferenceStore());
    }

    private void updateMaxDisplayedValue(IPreferenceStore prefs) {
        int newValue = Math.max(1, prefs.getInt("MAX_PROGRESS_ENTRIES"));
        this.setMaxDisplayed(newValue);
    }

    @Override
    public void add(JobTreeElement ... elements) {
        Control[] existingChildren;
        ViewerComparator sorter = this.getComparator();
        LinkedHashSet<JobTreeElement> newItems = new LinkedHashSet<JobTreeElement>(elements.length);
        Object[] objectArray = existingChildren = this.control.getChildren();
        int n = existingChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = objectArray[n2];
            if (child.getData() != null) {
                newItems.add((JobTreeElement)child.getData());
            }
            ++n2;
        }
        objectArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            Control element = objectArray[n2];
            if (element != null) {
                newItems.add((JobTreeElement)element);
            }
            ++n2;
        }
        Object[] infos = new JobTreeElement[newItems.size()];
        newItems.toArray(infos);
        if (sorter != null) {
            sorter.sort((Viewer)this, infos);
        }
        Control[] controlArray = existingChildren;
        int n3 = existingChildren.length;
        n = 0;
        while (n < n3) {
            Control child = controlArray[n];
            ((ProgressInfoItem)child).dispose();
            ++n;
        }
        int totalSize = Math.min(newItems.size(), this.getMaxDisplayed());
        int i = 0;
        while (i < totalSize) {
            ProgressInfoItem item = this.createNewItem((JobTreeElement)infos[i]);
            item.setColor(i);
            ++i;
        }
        this.updateForShowingProgress();
    }

    private void updateForShowingProgress() {
        if (this.control.getChildren().length > 0) {
            this.updateSize();
            this.scrolled.setContent((Control)this.control);
        } else {
            this.scrolled.setMinSize(null);
            this.scrolled.setContent((Control)this.noEntryArea);
        }
        this.control.requestLayout();
    }

    private ProgressInfoItem createNewItem(JobTreeElement info) {
        final ProgressInfoItem item = new ProgressInfoItem(this.control, 0, info);
        item.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                DetailedProgressViewer.this.updateVisibleProgressItems(new Control[]{item});
            }

            public void controlResized(ControlEvent e) {
                DetailedProgressViewer.this.updateVisibleProgressItems(new Control[]{item});
            }
        });
        item.setIndexListener(new ProgressInfoItem.IndexListener(){

            @Override
            public void selectNext() {
                DetailedProgressViewer.this.selectNext(item);
            }

            @Override
            public void selectPrevious() {
                DetailedProgressViewer.this.selectPrevious(item);
            }

            @Override
            public void select() {
                Control[] controlArray = DetailedProgressViewer.this.control.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control element = controlArray[n2];
                    ProgressInfoItem child = (ProgressInfoItem)element;
                    if (!((Object)((Object)item)).equals((Object)child)) {
                        child.selectWidgets(false);
                    }
                    ++n2;
                }
                item.selectWidgets(true);
            }
        });
        return item;
    }

    protected void selectPrevious(ProgressInfoItem item) {
        Control[] children = this.control.getChildren();
        int i = 0;
        while (i < children.length) {
            ProgressInfoItem child = (ProgressInfoItem)children[i];
            if (((Object)((Object)item)).equals((Object)child)) {
                ProgressInfoItem previous = i == 0 ? (ProgressInfoItem)children[children.length - 1] : (ProgressInfoItem)children[i - 1];
                item.selectWidgets(false);
                previous.selectWidgets(true);
                return;
            }
            ++i;
        }
    }

    protected void selectNext(ProgressInfoItem item) {
        Control[] children = this.control.getChildren();
        int i = 0;
        while (i < children.length) {
            ProgressInfoItem child = (ProgressInfoItem)children[i];
            if (((Object)((Object)item)).equals((Object)child)) {
                ProgressInfoItem next = i == children.length - 1 ? (ProgressInfoItem)children[0] : (ProgressInfoItem)children[i + 1];
                item.selectWidgets(false);
                next.selectWidgets(true);
                return;
            }
            ++i;
        }
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        Control[] controlArray = this.control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed() && control.getData() != null && control.getData().equals(element)) {
                return control;
            }
            ++n2;
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (this.usingElementMap()) {
            this.unmapElement(item);
        }
        item.dispose();
        this.add((JobTreeElement)element);
    }

    public Control getControl() {
        return this.scrolled;
    }

    protected List getSelectionFromWidget() {
        return new ArrayList(0);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.refreshAll();
    }

    protected void internalRefresh(Object element) {
        if (element == null) {
            return;
        }
        if (element.equals(this.getRoot())) {
            this.refreshAll();
            return;
        }
        Widget widget = this.findItem(element);
        if (widget == null) {
            this.add((JobTreeElement)element);
            return;
        }
        ((ProgressInfoItem)widget).refresh();
        this.updateSize();
    }

    @Override
    public void remove(JobTreeElement ... elements) {
        JobTreeElement[] jobTreeElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Widget item;
            JobTreeElement element;
            JobTreeElement treeElement = element = jobTreeElementArray[n2];
            if (FinishedJobs.getInstance().isKept(treeElement)) {
                item = this.doFindItem(element);
                if (item != null) {
                    ((ProgressInfoItem)item).refresh();
                }
            } else {
                JobTreeElement parent;
                item = this.doFindItem(treeElement);
                if (item == null && (parent = treeElement.getParent()) != null) {
                    item = this.doFindItem(parent);
                }
                if (item != null) {
                    this.unmapElement(element);
                    item.dispose();
                }
            }
            ++n2;
        }
        Control[] existingChildren = this.control.getChildren();
        int i = 0;
        while (i < existingChildren.length) {
            ProgressInfoItem item = (ProgressInfoItem)existingChildren[i];
            item.setColor(i);
            ++i;
        }
        this.updateForShowingProgress();
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    public void cancelSelection() {
    }

    public void setFocus() {
        Control[] children = this.control.getChildren();
        if (children.length > 0) {
            ((ProgressInfoItem)children[0]).setButtonFocus();
        } else {
            this.noEntryArea.setFocus();
        }
    }

    private void refreshAll() {
        Object[] infos = this.getSortedChildren(this.getRoot());
        Control[] controlArray = this.control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        int maxLength = Math.min(infos.length, this.getMaxDisplayed());
        int i = 0;
        while (i < maxLength) {
            ProgressInfoItem item = this.createNewItem((JobTreeElement)infos[i]);
            item.setColor(i);
            ++i;
        }
        this.updateForShowingProgress();
    }

    private void updateVisibleItems() {
        this.updateVisibleProgressItems(this.control.getChildren());
    }

    private void updateVisibleProgressItems(Control ... progressInfoItems) {
        int top = this.scrolled.getOrigin().y;
        int bottom = top + this.scrolled.getParent().getBounds().height;
        Control[] controlArray = progressInfoItems;
        int n = progressInfoItems.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            ProgressInfoItem item = (ProgressInfoItem)control;
            item.setDisplayed(top, bottom);
            ++n2;
        }
    }

    private void updateSize() {
        Point size = this.control.computeSize(-1, -1);
        size.x += 4;
        size.y += 4;
        this.scrolled.setMinSize(size);
    }

    public ProgressInfoItem[] getProgressInfoItems() {
        Control[] children = this.control.getChildren();
        ProgressInfoItem[] progressInfoItems = new ProgressInfoItem[children.length];
        System.arraycopy(children, 0, progressInfoItems, 0, children.length);
        return progressInfoItems;
    }

    public int getMaxDisplayed() {
        return this.maxDisplayed;
    }

    public void setMaxDisplayed(int maxDisplayed) {
        this.maxDisplayed = maxDisplayed;
    }
}

