/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.history;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.history.LocalFileRevision;

public class LocalFileHistory
extends FileHistory {
    protected IFile file;
    protected IFileRevision[] revisions;
    private final boolean includeCurrent;

    public LocalFileHistory(IFile file, boolean includeCurrent) {
        this.file = file;
        this.includeCurrent = includeCurrent;
    }

    @Override
    public IFileRevision[] getContributors(IFileRevision revision) {
        IFileRevision[] revisions = this.getFileRevisions();
        IFileRevision fileRevision = null;
        IFileRevision[] iFileRevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            IFileRevision r = iFileRevisionArray[n2];
            if (((LocalFileRevision)r).isPredecessorOf(revision)) {
                if (fileRevision == null) {
                    fileRevision = r;
                }
                if (fileRevision != null && r.getTimestamp() > fileRevision.getTimestamp()) {
                    fileRevision = r;
                }
            }
            ++n2;
        }
        if (fileRevision == null) {
            return new IFileRevision[0];
        }
        return new IFileRevision[]{fileRevision};
    }

    @Override
    public IFileRevision getFileRevision(String id) {
        if (this.revisions != null) {
            IFileRevision[] iFileRevisionArray = this.revisions;
            int n = this.revisions.length;
            int n2 = 0;
            while (n2 < n) {
                IFileRevision revision = iFileRevisionArray[n2];
                if (revision.getContentIdentifier().equals(id)) {
                    return revision;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IFileRevision[] getFileRevisions() {
        if (this.revisions == null) {
            return new IFileRevision[0];
        }
        return this.revisions;
    }

    @Override
    public IFileRevision[] getTargets(IFileRevision revision) {
        IFileRevision[] revisions = this.getFileRevisions();
        ArrayList<IFileRevision> directDescendents = new ArrayList<IFileRevision>();
        IFileRevision[] iFileRevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            IFileRevision r = iFileRevisionArray[n2];
            if (((LocalFileRevision)r).isDescendentOf(revision)) {
                directDescendents.add(r);
            }
            ++n2;
        }
        return directDescendents.toArray(new IFileRevision[directDescendents.size()]);
    }

    public void refresh(IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(Messages.LocalFileHistory_RefreshLocalHistory, 300);
        try {
            try {
                LocalFileRevision currentRevision = this.includeRevisionForFile() ? new LocalFileRevision(this.file) : null;
                IFileState[] fileStates = this.file.getHistory(monitor);
                int numRevisions = fileStates.length + (currentRevision != null ? 1 : 0);
                this.revisions = new LocalFileRevision[numRevisions];
                int i = 0;
                while (i < fileStates.length) {
                    this.revisions[i] = new LocalFileRevision(fileStates[i]);
                    ++i;
                }
                if (currentRevision != null) {
                    this.revisions[fileStates.length] = currentRevision;
                }
            }
            catch (CoreException e) {
                throw TeamException.asTeamException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean includeRevisionForFile() {
        return this.file.exists() && this.includeCurrent;
    }
}

