/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;

public class ProjectDiscoveryHelper {
    @Inject
    protected NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;
    @Inject
    protected ProjectDescriptionLoader projectDescriptionLoader;

    public LinkedHashSet<Path> collectAllProjectDirs(Path ... workspaceRoots) {
        HashMap<Path, ProjectDescription> pdCache = new HashMap<Path, ProjectDescription>();
        LinkedHashSet<Path> allProjectDirs = this.collectAllProjects(workspaceRoots, pdCache);
        LinkedHashSet<Path> dependencies = this.collectNecessaryDependencies(allProjectDirs, pdCache);
        allProjectDirs.addAll(dependencies);
        return allProjectDirs;
    }

    private LinkedHashSet<Path> collectAllProjects(Path[] workspaceRoots, Map<Path, ProjectDescription> pdCache) {
        LinkedHashSet<Path> allProjectDirs = new LinkedHashSet<Path>();
        Path[] pathArray = workspaceRoots;
        int n = workspaceRoots.length;
        int n2 = 0;
        while (n2 < n) {
            Path wsRoot = pathArray[n2];
            NodeModulesDiscoveryHelper.NodeModulesFolder nodeModulesFolder = this.nodeModulesDiscoveryHelper.getNodeModulesFolder(wsRoot, pdCache);
            if (nodeModulesFolder == null) {
                this.collectProjects(wsRoot, false, pdCache, allProjectDirs);
            } else if (nodeModulesFolder.isYarnWorkspace) {
                Path yarnProjectDir = nodeModulesFolder.nodeModulesFolder.getParentFile().toPath();
                this.collectYarnWorkspaceProjects(yarnProjectDir, pdCache, allProjectDirs);
            } else {
                allProjectDirs.add(wsRoot);
            }
            ++n2;
        }
        return allProjectDirs;
    }

    private void collectYarnWorkspaceProjects(Path yarnProjectRoot, Map<Path, ProjectDescription> pdCache, Set<Path> projects) {
        EList workspaces;
        projects.add(yarnProjectRoot);
        ProjectDescription projectDescription = this.getCachedProjectDescription(yarnProjectRoot, pdCache);
        EList eList = workspaces = projectDescription == null ? null : projectDescription.getWorkspaces();
        if (workspaces == null) {
            return;
        }
        for (String workspaceGlob : workspaces) {
            this.collectGlobMatches(workspaceGlob, yarnProjectRoot, pdCache, projects);
        }
    }

    private void collectProjects(final Path root, boolean includeSubtree, final Map<Path, ProjectDescription> pdCache, final Set<Path> allProjectDirs) {
        int depth;
        FileVisitResult defaultReturn;
        if (!root.toFile().isDirectory()) {
            return;
        }
        if (includeSubtree) {
            defaultReturn = FileVisitResult.CONTINUE;
            depth = Integer.MAX_VALUE;
        } else {
            defaultReturn = FileVisitResult.SKIP_SUBTREE;
            depth = 3;
        }
        try {
            EnumSet<FileVisitOption> none = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(root, none, depth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (root.equals(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (dir.toFile().getName().startsWith("@")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (dir.endsWith("node_modules")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    File pckJson = dir.resolve("package.json").toFile();
                    if (pckJson.isFile()) {
                        if (!root.endsWith("node_modules") && ProjectDiscoveryHelper.this.nodeModulesDiscoveryHelper.isYarnWorkspaceRoot(dir.toFile(), pdCache)) {
                            ProjectDiscoveryHelper.this.collectYarnWorkspaceProjects(dir, pdCache, allProjectDirs);
                        } else {
                            allProjectDirs.add(dir);
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return defaultReturn;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void collectGlobMatches(String glob, Path location, final Map<Path, ProjectDescription> pdCache, final Set<Path> allProjectDirs) {
        int depth = glob.contains("**") ? Integer.MAX_VALUE : glob.split("/").length + 1;
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + location.resolve(glob));
        try {
            EnumSet<FileVisitOption> none = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(location, none, depth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (dir.endsWith("node_modules")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (pathMatcher.matches(dir)) {
                        Path dirName = dir.getName(dir.getNameCount() - 1);
                        if (dirName.toString().startsWith("@")) {
                            ProjectDiscoveryHelper.this.collectProjects(dir, false, pdCache, allProjectDirs);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        File pckJson = dir.resolve("package.json").toFile();
                        if (pckJson.isFile()) {
                            allProjectDirs.add(dir);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ProjectDescription getCachedProjectDescription(Path path, Map<Path, ProjectDescription> cache) {
        if (!cache.containsKey(path)) {
            FileURI uri = new FileURI(path.toFile());
            ProjectDescription depPD = this.projectDescriptionLoader.loadProjectDescriptionAtLocation(uri);
            cache.put(path, depPD);
        }
        return cache.get(path);
    }

    private LinkedHashSet<Path> collectAllDependencies(LinkedHashSet<Path> allProjectDirs, Map<Path, ProjectDescription> pdCache) {
        LinkedHashSet<Path> dependencies = new LinkedHashSet<Path>();
        List<Path> nodeModulesFolders = this.nodeModulesDiscoveryHelper.findNodeModulesFolders(allProjectDirs, pdCache);
        for (Path nmFolder : new LinkedHashSet<Path>(nodeModulesFolders)) {
            this.collectProjects(nmFolder, true, pdCache, dependencies);
        }
        return dependencies;
    }

    private LinkedHashSet<Path> collectNecessaryDependencies(LinkedHashSet<Path> allProjectDirs, Map<Path, ProjectDescription> pdCache) {
        LinkedHashSet<Path> dependencies = new LinkedHashSet<Path>();
        for (Path nextProject : allProjectDirs) {
            this.collectProjectDependencies(nextProject, pdCache, dependencies);
        }
        return dependencies;
    }

    private void collectProjectDependencies(Path projectDir, Map<Path, ProjectDescription> pdCache, LinkedHashSet<Path> dependencies) {
        NodeModulesDiscoveryHelper.NodeModulesFolder nodeModulesFolder = this.nodeModulesDiscoveryHelper.getNodeModulesFolder(projectDir, pdCache);
        Path topNodeModules = nodeModulesFolder != null ? nodeModulesFolder.nodeModulesFolder.toPath() : null;
        LinkedHashSet<Path> workList = new LinkedHashSet<Path>();
        workList.add(projectDir);
        while (!workList.isEmpty()) {
            Iterator iterator = workList.iterator();
            Path nextProject = (Path)iterator.next();
            iterator.remove();
            this.findDependencies(nextProject, topNodeModules, pdCache, workList, dependencies);
        }
    }

    private void findDependencies(Path prjDir, Path topNodeModules, Map<Path, ProjectDescription> pdCache, Set<Path> workList, Set<Path> dependencies) {
        Path prjNodeModules = prjDir.resolve("node_modules");
        ProjectDescription prjDescr = this.getCachedProjectDescription(prjDir, pdCache);
        if (prjDescr == null) {
            return;
        }
        for (ProjectDependency dependency : prjDescr.getProjectDependencies()) {
            Path depLocation;
            String depName = dependency.getProjectName();
            Path path = depLocation = topNodeModules == null ? prjNodeModules.resolve(depName) : topNodeModules.resolve(depName);
            if (prjDir.equals(depLocation)) continue;
            this.addDependency(depLocation, pdCache, workList, dependencies);
        }
    }

    private void addDependency(Path depLocation, Map<Path, ProjectDescription> pdCache, Set<Path> workList, Set<Path> dependencies) {
        if (dependencies.contains(depLocation)) {
            return;
        }
        Path packageJson = depLocation.resolve("package.json");
        if (packageJson.toFile().isFile()) {
            dependencies.add(depLocation);
            ProjectDescription depPD = this.getCachedProjectDescription(depLocation, pdCache);
            if (depPD != null && depPD.isHasN4JSNature()) {
                workList.add(depLocation);
            }
        }
    }
}

