/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ThisArgProvider;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.Script_IM;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.EcoreUtil2;

public class TranspilerUtils {
    public static boolean isOriginalASTNode(EObject eobj) {
        Script script = (Script)EcoreUtil2.getContainerOfType((EObject)eobj, Script.class);
        return script != null && !(script instanceof Script_IM);
    }

    public static final void assertOriginalASTNode(EObject originalASTNode) {
        if (!TranspilerUtils.isOriginalASTNode(originalASTNode)) {
            throw new IllegalArgumentException("not a node from the original AST");
        }
    }

    public static boolean isIntermediateModelElement(EObject eobj) {
        return EcoreUtil2.getContainerOfType((EObject)eobj, Script_IM.class) != null;
    }

    public static final void assertIntermediateModelElement(EObject elementInIntermediateModel) {
        if (!TranspilerUtils.isIntermediateModelElement(elementInIntermediateModel)) {
            throw new IllegalArgumentException("not an element from the intermediate model");
        }
    }

    public static final <T extends EObject> List<T> collectNodes(EObject root, Class<T> cls, boolean searchForNestedNodes) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (!cls.isAssignableFrom(obj.getClass())) continue;
            EObject objCasted = obj;
            result.add(objCasted);
            if (searchForNestedNodes) continue;
            iter.prune();
        }
        return result;
    }

    public static final <T extends EObject> List<T> collectNodesWithinSameThisEnvironment(EObject root, Class<T> cls) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (cls.isAssignableFrom(obj.getClass())) {
                EObject objCasted = obj;
                result.add(objCasted);
            }
            if (!(obj instanceof ThisArgProvider)) continue;
            iter.prune();
        }
        return result;
    }

    public static final EObject orContainingExportDeclaration(EObject eobj) {
        EObject parent = eobj.eContainer();
        if (parent instanceof ExportDeclaration) {
            return parent;
        }
        return eobj;
    }

    public static String sanitizeIdentifierName(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        char ch = input.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            result.append(ch);
        } else {
            result.append("_" + Character.codePointAt(input, 0) + "$");
        }
        int i = 1;
        while (i < input.length()) {
            ch = input.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                result.append(ch);
            } else {
                result.append("_" + Character.codePointAt(input, i) + "$");
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean isLegalIdentifier(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDefSiteStructural(TN4Classifier type) {
        TypingStrategy ts = type.getTypingStrategy();
        return TypeUtils.isStructural((TypingStrategy)ts);
    }

    public static boolean hasNonTrivialInitExpression(RuleEnvironment G, N4FieldDeclaration fieldDecl) {
        Expression expr;
        Expression expression = expr = fieldDecl != null ? fieldDecl.getExpression() : null;
        if (expr instanceof IdentifierRef_IM && ((IdentifierRef_IM)expr).getOriginalTargetOfRewiredTarget() == RuleEnvironmentExtensions.getGlobalObjectScope((RuleEnvironment)G).getFieldUndefined()) {
            return false;
        }
        return expr != null && !N4JSLanguageUtils.isUndefinedLiteral((RuleEnvironment)G, (Expression)expr);
    }
}

