/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.transpiler.AbstractTranspiler;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.es.transform.ApiImplStubGenerationTransformation;
import org.eclipse.n4js.transpiler.es.transform.ArrowFunction_Part1_Transformation;
import org.eclipse.n4js.transpiler.es.transform.ArrowFunction_Part2_Transformation;
import org.eclipse.n4js.transpiler.es.transform.BlockTransformation;
import org.eclipse.n4js.transpiler.es.transform.ClassDeclarationTransformation;
import org.eclipse.n4js.transpiler.es.transform.DependencyInjectionTransformation;
import org.eclipse.n4js.transpiler.es.transform.DestructuringTransformation;
import org.eclipse.n4js.transpiler.es.transform.EnumAccessTransformation;
import org.eclipse.n4js.transpiler.es.transform.EnumDeclarationTransformation;
import org.eclipse.n4js.transpiler.es.transform.ExpressionTransformation;
import org.eclipse.n4js.transpiler.es.transform.InterfaceDeclarationTransformation;
import org.eclipse.n4js.transpiler.es.transform.JSXTransformation;
import org.eclipse.n4js.transpiler.es.transform.MemberPatchingTransformation;
import org.eclipse.n4js.transpiler.es.transform.ModuleWrappingTransformation;
import org.eclipse.n4js.transpiler.es.transform.RestParameterTransformation;
import org.eclipse.n4js.transpiler.es.transform.SanitizeImportsTransformation;
import org.eclipse.n4js.transpiler.es.transform.StaticPolyfillTransformation;
import org.eclipse.n4js.transpiler.es.transform.TemplateStringTransformation;
import org.eclipse.n4js.transpiler.es.transform.TrimTransformation;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class EcmaScriptTranspiler
extends AbstractTranspiler {
    @Inject
    private Provider<DestructuringTransformation> destructuringTransformation;
    @Inject
    private Provider<MemberPatchingTransformation> memberPatchingTransformationProvider;
    @Inject
    private Provider<ApiImplStubGenerationTransformation> apiImplStubGenerationTransformationProvider;
    @Inject
    private Provider<StaticPolyfillTransformation> staticPolyfillTransformationProvider;
    @Inject
    private Provider<TemplateStringTransformation> templateStringTransformationProvider;
    @Inject
    private Provider<ExpressionTransformation> expressionTransformationProvider;
    @Inject
    private Provider<EnumAccessTransformation> enumAccessTransformationProvider;
    @Inject
    private Provider<DependencyInjectionTransformation> dependencyInjectionTransformation;
    @Inject
    private Provider<ClassDeclarationTransformation> classDeclarationTransformationProvider;
    @Inject
    private Provider<InterfaceDeclarationTransformation> interfaceDeclarationTransformationProvider;
    @Inject
    private Provider<EnumDeclarationTransformation> enumDeclarationTransformationProvider;
    @Inject
    private Provider<TrimTransformation> trimTransformation;
    @Inject
    private Provider<SanitizeImportsTransformation> sanitizeImportsTransformationProvider;
    @Inject
    private Provider<ModuleWrappingTransformation> moduleWrappingTransformationProvider;
    @Inject
    private Provider<BlockTransformation> blockTransformationProvider;
    @Inject
    private Provider<RestParameterTransformation> restParameterTransformationProvider;
    @Inject
    private Provider<ArrowFunction_Part1_Transformation> arrowFunction_Part1_TransformationProvider;
    @Inject
    private Provider<ArrowFunction_Part2_Transformation> arrowFunction_Part2_TransformationProvider;
    @Inject
    private Provider<JSXTransformation> jsxTransformationProvider;

    protected Optional<String> getPreamble() {
        return Optional.of((Object)"// Generated by N4JS transpiler; for copyright see original N4JS source file.\n");
    }

    protected Transformation[] computeTransformationsToBeExecuted(TranspilerState state) {
        return new Transformation[]{(Transformation)this.jsxTransformationProvider.get(), (Transformation)this.staticPolyfillTransformationProvider.get(), (Transformation)this.memberPatchingTransformationProvider.get(), (Transformation)this.apiImplStubGenerationTransformationProvider.get(), (Transformation)this.destructuringTransformation.get(), (Transformation)this.templateStringTransformationProvider.get(), (Transformation)this.expressionTransformationProvider.get(), (Transformation)this.enumAccessTransformationProvider.get(), (Transformation)this.dependencyInjectionTransformation.get(), (Transformation)this.enumDeclarationTransformationProvider.get(), (Transformation)this.classDeclarationTransformationProvider.get(), (Transformation)this.interfaceDeclarationTransformationProvider.get(), (Transformation)this.arrowFunction_Part1_TransformationProvider.get(), (Transformation)this.blockTransformationProvider.get(), (Transformation)this.restParameterTransformationProvider.get(), (Transformation)this.arrowFunction_Part2_TransformationProvider.get(), (Transformation)this.trimTransformation.get(), (Transformation)this.sanitizeImportsTransformationProvider.get(), (Transformation)this.moduleWrappingTransformationProvider.get()};
    }

    public void transpile(N4JSResource resource, GeneratorOption[] options, Writer outCode, Optional<AbstractTranspiler.SourceMapInfo> optSourceMapInfo) {
        if (!this.requiresTranspilation(resource)) {
            this.copyWithoutTranspilation(resource, outCode);
        } else {
            super.transpile(resource, options, outCode, optSourceMapInfo);
        }
    }

    private void copyWithoutTranspilation(N4JSResource resource, Writer outCode) {
        EObject script = (EObject)resource.getContents().get(0);
        String scriptAsText = NodeModelUtils.getNode((EObject)script).getRootNode().getText();
        String decorated = scriptAsText.toString();
        try {
            outCode.write(decorated);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean requiresTranspilation(N4JSResource eResource) {
        ResourceType resourceType = ResourceType.getResourceType((Resource)eResource);
        return !resourceType.equals((Object)ResourceType.JS) && !resourceType.equals((Object)ResourceType.JSX);
    }
}

