/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui.resultsview;

import java.util.Arrays;
import org.eclipse.n4js.tester.domain.TestStatus;

public class TestStatusCounter {
    private final int[] count = new int[TestStatus.values().length];

    public void clear() {
        Arrays.fill(this.count, 0);
    }

    public void increment(TestStatus status) {
        int n = status.ordinal();
        this.count[n] = this.count[n] + 1;
    }

    public void increment(TestStatusCounter other) {
        int i = 0;
        while (i < this.count.length) {
            int n = i;
            this.count[n] = this.count[n] + other.count[i];
            ++i;
        }
    }

    public int getCount(TestStatus ... testStatus) {
        int sum = 0;
        TestStatus[] testStatusArray = testStatus;
        int n = testStatus.length;
        int n2 = 0;
        while (n2 < n) {
            TestStatus status = testStatusArray[n2];
            sum += this.count[status.ordinal()];
            ++n2;
        }
        return sum;
    }

    public int getTotal() {
        int result = 0;
        int i = 0;
        while (i < this.count.length) {
            result += this.count[i];
            ++i;
        }
        return result;
    }

    public TestStatus getAggregatedStatus() {
        if (this.getCount(TestStatus.ERROR) > 0) {
            return TestStatus.ERROR;
        }
        if (this.getCount(TestStatus.FAILED) > 0) {
            return TestStatus.FAILED;
        }
        if (this.getCount(TestStatus.SKIPPED_FIXME) > 0) {
            return TestStatus.SKIPPED_FIXME;
        }
        if (this.getCount(TestStatus.PASSED) > 0) {
            return TestStatus.PASSED;
        }
        if (this.getCount(TestStatus.SKIPPED) > 0) {
            return TestStatus.SKIPPED;
        }
        if (this.getCount(TestStatus.SKIPPED_NOT_IMPLEMENTED) > 0) {
            return TestStatus.SKIPPED_NOT_IMPLEMENTED;
        }
        if (this.getCount(TestStatus.SKIPPED_PRECONDITION) > 0) {
            return TestStatus.SKIPPED_PRECONDITION;
        }
        if (this.getCount(TestStatus.SKIPPED_IGNORE) > 0) {
            return TestStatus.SKIPPED_IGNORE;
        }
        return null;
    }

    public TestStatus containsSkipped() {
        if (this.getCount(TestStatus.SKIPPED_FIXME) > 0) {
            return TestStatus.SKIPPED_FIXME;
        }
        if (this.getCount(TestStatus.SKIPPED) > 0) {
            return TestStatus.SKIPPED;
        }
        if (this.getCount(TestStatus.SKIPPED_NOT_IMPLEMENTED) > 0) {
            return TestStatus.SKIPPED_NOT_IMPLEMENTED;
        }
        if (this.getCount(TestStatus.SKIPPED_PRECONDITION) > 0) {
            return TestStatus.SKIPPED_PRECONDITION;
        }
        if (this.getCount(TestStatus.SKIPPED_IGNORE) > 0) {
            return TestStatus.SKIPPED_IGNORE;
        }
        if (this.getCount(TestStatus.PASSED) > 0) {
            return TestStatus.PASSED;
        }
        return null;
    }

    public String toString() {
        return this.toString(true, -1, 131072);
    }

    public String toString(boolean showSkipped, int pending, int alignment) {
        int skipped = showSkipped ? this.getCount(TestStatus.SKIPPED, TestStatus.SKIPPED_NOT_IMPLEMENTED, TestStatus.SKIPPED_PRECONDITION, TestStatus.SKIPPED_IGNORE, TestStatus.SKIPPED_FIXME) : 0;
        StringBuffer sb = new StringBuffer();
        if (alignment == 16384 && (skipped > 0 || pending > 0)) {
            sb.append("(");
            if (pending > 0) {
                sb.append(String.valueOf(pending) + " pending");
            }
            if (pending > 0 && skipped > 0) {
                sb.append(", ");
            }
            if (skipped > 0) {
                sb.append(String.valueOf(skipped) + " skipped");
            }
            sb.append(")  ");
        }
        sb.append(this.getCount(TestStatus.PASSED));
        sb.append(" | ");
        sb.append(this.getCount(TestStatus.FAILED));
        sb.append(" | ");
        sb.append(this.getCount(TestStatus.ERROR));
        if (alignment == 131072 && (skipped > 0 || pending > 0)) {
            sb.append("  (");
            if (skipped > 0) {
                sb.append("skipped " + skipped);
            }
            if (pending > 0 && skipped > 0) {
                sb.append(", ");
            }
            if (pending > 0) {
                sb.append("pending " + pending);
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

