/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow.symbols;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolOfIdentifierRef;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolOfNullLiteral;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolOfParameterizedPropertyAccessExpression;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolOfSuperLiteral;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolOfThisLiteral;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolOfUndefined;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolOfVariableDeclaration;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolOfZeroLiteral;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IntLiteral;
import org.eclipse.n4js.n4JS.N4JSFactory;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.impl.IdentifierRefImpl;
import org.eclipse.n4js.n4JS.impl.NullLiteralImpl;
import org.eclipse.n4js.n4JS.impl.NumericLiteralImpl;
import org.eclipse.n4js.n4JS.impl.SuperLiteralImpl;
import org.eclipse.n4js.n4JS.impl.ThisLiteralImpl;
import org.eclipse.n4js.n4JS.impl.UnaryExpressionImpl;
import org.eclipse.n4js.n4JS.impl.VariableDeclarationImpl;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.TypesFactory;

public class SymbolFactory {
    private Symbol undefined;
    private final Map<Symbol, Symbol> symbols = new HashMap<Symbol, Symbol>();
    static final Map<Class<? extends ControlFlowElement>, Function<ControlFlowElement, Symbol>> symbolCreators = new HashMap<Class<? extends ControlFlowElement>, Function<ControlFlowElement, Symbol>>();

    static {
        symbolCreators.put(VariableDeclarationImpl.class, SymbolFactory::createFromVariableDeclaration);
        symbolCreators.put(IdentifierRefImpl.class, SymbolFactory::createFromIdentifierRef);
        symbolCreators.put(NullLiteralImpl.class, SymbolFactory::createFromNullLiteral);
        symbolCreators.put(UnaryExpressionImpl.class, SymbolFactory::createFromUnaryExpression);
        symbolCreators.put(ThisLiteralImpl.class, SymbolFactory::createFromThisLiteral);
        symbolCreators.put(SuperLiteralImpl.class, SymbolFactory::createFromSuperLiteral);
        symbolCreators.put(NumericLiteralImpl.class, SymbolFactory::createFromNumericLiteral);
    }

    private static Symbol createFromVariableDeclaration(ControlFlowElement cfe) {
        return new SymbolOfVariableDeclaration((VariableDeclaration)cfe);
    }

    private static Symbol createFromIdentifierRef(ControlFlowElement cfe) {
        IdentifierRef idRef = (IdentifierRef)cfe;
        IdentifiableElement id = SymbolFactory.getId(idRef);
        if (id != null) {
            if (id instanceof TVariable && !((TVariable)id).isConst()) {
                return null;
            }
            return new SymbolOfIdentifierRef(id, idRef);
        }
        return null;
    }

    private static Symbol createFromParameterizedPropertyAccessExpression(ControlFlowElement cfe) {
        return null;
    }

    private static Symbol createFromNullLiteral(ControlFlowElement cfe) {
        return new SymbolOfNullLiteral((NullLiteral)cfe);
    }

    private static Symbol createFromUnaryExpression(ControlFlowElement cfe) {
        UnaryExpression ue = (UnaryExpression)cfe;
        if (ue.getOp() == UnaryOperator.VOID) {
            return new SymbolOfUndefined((Expression)ue);
        }
        return null;
    }

    private static Symbol createFromThisLiteral(ControlFlowElement cfe) {
        return new SymbolOfThisLiteral((ThisLiteral)cfe);
    }

    private static Symbol createFromSuperLiteral(ControlFlowElement cfe) {
        return new SymbolOfSuperLiteral((SuperLiteral)cfe);
    }

    private static Symbol createFromNumericLiteral(ControlFlowElement cfe) {
        if (new BigDecimal(0).equals(((NumericLiteral)cfe).getValue())) {
            return new SymbolOfZeroLiteral((NumericLiteral)cfe);
        }
        return null;
    }

    public static boolean canCreate(ControlFlowElement cfe) {
        if (cfe == null) {
            return false;
        }
        return symbolCreators.containsKey(cfe.getClass());
    }

    public Symbol create(ControlFlowElement cfe) {
        Symbol newSymbol;
        Function<ControlFlowElement, Symbol> creatorFunction;
        if (cfe != null && (creatorFunction = symbolCreators.get(cfe.getClass())) != null && (newSymbol = creatorFunction.apply(cfe)) != null) {
            this.symbols.putIfAbsent(newSymbol, newSymbol);
            Symbol symbol = this.symbols.get(newSymbol);
            return symbol;
        }
        return null;
    }

    public Symbol create(Expression baseExpression, List<Symbol> wrappers) {
        if (wrappers.isEmpty()) {
            return this.create((ControlFlowElement)baseExpression);
        }
        Expression lastTarget = (Expression)EcoreUtil.copy((EObject)baseExpression);
        for (Symbol wrapper : wrappers) {
            ParameterizedPropertyAccessExpression ppae = ((SymbolOfParameterizedPropertyAccessExpression)wrapper).ppae;
            ParameterizedPropertyAccessExpression copy = N4JSFactory.eINSTANCE.createParameterizedPropertyAccessExpression();
            copy.setProperty(ppae.getProperty());
            copy.setTarget(lastTarget);
            lastTarget = copy;
        }
        ParameterizedPropertyAccessExpression ppae = (ParameterizedPropertyAccessExpression)lastTarget;
        return new SymbolOfParameterizedPropertyAccessExpression(this, ppae);
    }

    public static IdentifiableElement getId(IdentifierRef idRef) {
        IdentifiableElement id;
        if (idRef instanceof IdentifierRefImpl && (id = ((IdentifierRefImpl)idRef).basicGetId()) != null && !id.eIsProxy()) {
            return id;
        }
        return null;
    }

    public static boolean isUndefined(Expression expr) {
        IdentifiableElement id;
        return expr instanceof IdentifierRef && (id = SymbolFactory.getId((IdentifierRef)expr)) != null && "undefined".equals(id.getName());
    }

    public static boolean isZero(Expression expr) {
        return expr instanceof IntLiteral && new BigDecimal(0).equals(((NumericLiteral)expr).getValue());
    }

    public Symbol getUndefined() {
        if (this.undefined == null) {
            IdentifiableElement ieUndefined = TypesFactory.eINSTANCE.createIdentifiableElement();
            IdentifierRef irUndefined = N4JSFactory.eINSTANCE.createIdentifierRef();
            irUndefined.setId(ieUndefined);
            ieUndefined.setName("undefined");
            this.undefined = this.create((ControlFlowElement)irUndefined);
        }
        return this.undefined;
    }
}

