/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import java.security.Permission;

public class SystemExitRedirecter {
    public void set() {
        System.setSecurityManager(new NoExitSecurityManager());
    }

    public void unset() {
        System.setSecurityManager(null);
    }

    private static class NoExitSecurityManager
    extends SecurityManager {
        private final SecurityManager securityManager = System.getSecurityManager();

        NoExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
            if (this.securityManager != null) {
                this.securityManager.checkPermission(perm);
            }
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.securityManager != null) {
                this.securityManager.checkPermission(perm, context);
            }
        }

        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            throw new SystemExitException(status);
        }
    }

    static class SystemExitException
    extends SecurityException {
        public final int status;

        public SystemExitException(int status) {
            this.status = status;
        }
    }
}

