/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ExtensionAttributeRow;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ChoiceAttributeRow
extends ExtensionAttributeRow {
    protected ComboPart combo;

    public ChoiceAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    @Override
    public void createContents(Composite parent, FormToolkit toolkit, int span) {
        super.createContents(parent, toolkit, span);
        this.createLabel(parent, toolkit);
        this.combo = new ComboPart();
        this.combo.createControl(parent, toolkit, 8);
        ISchemaSimpleType type = this.getAttribute().getType();
        ISchemaRestriction restriction = type.getRestriction();
        if (restriction != null) {
            Object[] rchildren = restriction.getChildren();
            if (this.getUse() != 1) {
                this.combo.add("");
            }
            Object[] objectArray = rchildren;
            int n = rchildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object rchild = objectArray[n2];
                if (rchild instanceof ISchemaEnumeration) {
                    this.combo.add(((ISchemaEnumeration)rchild).getName());
                }
                ++n2;
            }
        }
        GridData gd = new GridData(span == 2 ? 768 : 256);
        gd.widthHint = 20;
        gd.horizontalSpan = span - 1;
        gd.horizontalIndent = 3;
        this.combo.getControl().setLayoutData((Object)gd);
        this.combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.blockNotification) {
                this.markDirty();
            }
        }));
        this.combo.getControl().setEnabled(this.part.isEditable());
    }

    @Override
    protected void update() {
        this.blockNotification = true;
        String value = this.getValue();
        if (value != null && this.isValid(value)) {
            this.combo.setText(value);
        } else if (this.getUse() == 1) {
            this.combo.setText(this.getValidValue());
        } else {
            this.combo.setText("");
        }
        this.blockNotification = false;
        this.dirty = false;
    }

    protected String getValidValue() {
        ISchemaAttribute attInfo = this.getAttribute();
        if (attInfo.getType().getRestriction() != null) {
            return attInfo.getType().getRestriction().getChildren()[0].toString();
        }
        return "";
    }

    protected boolean isValid(String value) {
        Object[] children;
        if (this.getAttribute().getUse() != 1 && value.equals("")) {
            return true;
        }
        ISchemaRestriction restriction = this.getAttribute().getType().getRestriction();
        if (restriction == null) {
            return true;
        }
        Object[] objectArray = children = restriction.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object rchild = objectArray[n2];
            if (rchild instanceof ISchemaEnumeration && ((ISchemaEnumeration)rchild).getName().equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void commit() {
        if (this.dirty && this.input != null) {
            try {
                String selection = this.combo.getSelection();
                if (selection.length() == 0) {
                    selection = null;
                }
                this.input.setAttribute(this.getName(), selection);
                this.dirty = false;
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    @Override
    public void setFocus() {
        this.combo.getControl().setFocus();
    }
}

