/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.print;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.transpiler.sourcemap.FilePosition;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class PositionProvider {
    private final int[] lineStarts;

    public PositionProvider(InputStream in) throws IOException {
        int i;
        Reader r = new InputStreamReader(in);
        r = new BufferedReader(r);
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int idx = -1;
        starts.add(0);
        while ((i = r.read()) != -1) {
            ++idx;
            char ch = (char)i;
            if (ch != '\n') continue;
            starts.add(idx + 1);
        }
        starts.add(Integer.MAX_VALUE);
        this.lineStarts = starts.stream().mapToInt(k -> k).toArray();
    }

    public static PositionProvider from(N4JSResource resource) {
        String originalSource = NodeModelUtils.getNode((EObject)resource.getScript()).getText();
        ByteArrayInputStream in = new ByteArrayInputStream(originalSource.getBytes());
        try {
            PositionProvider pp = new PositionProvider(in);
            ((InputStream)in).close();
            return pp;
        }
        catch (IOException e) {
            throw new WrappedException("exception while trying to compute line/column positions in resource", (Exception)e);
        }
    }

    public int findLine(int offset) {
        int line = this.lineStarts.length - 1;
        while (this.lineStarts[line] > offset && line > 0) {
            --line;
        }
        return line;
    }

    public int findColumn(int offset) {
        int line = this.findLine(offset);
        int offsetAtLineStart = this.lineStarts[line];
        return offset - offsetAtLineStart;
    }

    public int length(int line) {
        int offsetStart = this.lineStarts[line];
        int offsetEnd = this.lineStarts[line + 1];
        return offsetEnd - offsetStart;
    }

    public FilePosition toPosition(int offset) {
        int line = this.findLine(offset);
        int offsetAtLineStart = this.lineStarts[line];
        int col = offset - offsetAtLineStart;
        return new FilePosition(line, col);
    }
}

