/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.ArrayList;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class TopLevelNode
extends DTDNode {
    private ArrayList flatNodes = new ArrayList();

    public TopLevelNode(DTDFile dtdFile, IStructuredDocumentRegion flatNode) {
        super(dtdFile, flatNode);
        this.flatNodes.add(flatNode);
    }

    public void addWhitespaceStructuredDocumentRegion(IStructuredDocumentRegion node) {
        this.flatNodes.add(node);
    }

    public void delete() {
        this.beginRecording(this.getDTDFile(), DTDCoreMessages._UI_LABEL_TOP_LEVEL_NODE_DELETE);
        IStructuredDocumentRegion first = (IStructuredDocumentRegion)this.flatNodes.get(0);
        IStructuredDocumentRegion last = (IStructuredDocumentRegion)this.flatNodes.get(this.flatNodes.size() - 1);
        int startOffset = first.getStartOffset();
        int endOffset = last.getEndOffset();
        this.replaceText(this.getDTDFile(), startOffset, endOffset - startOffset, "");
        this.endRecording(this.getDTDFile());
    }

    @Override
    public ITextRegion getEndRegion() {
        int size = this.flatNode.getRegions().size();
        if (size > 0) {
            return this.flatNode.getRegions().get(size - 1);
        }
        return null;
    }

    public String getFullText() {
        StringBuffer sb = new StringBuffer();
        for (IStructuredDocumentRegion fNode : this.flatNodes) {
            sb.append(fNode.getText());
        }
        return sb.toString();
    }

    @Override
    public ITextRegion getStartRegion() {
        if (this.flatNode.getRegions().size() > 0) {
            return this.flatNode.getRegions().get(0);
        }
        return null;
    }

    @Override
    public RegionIterator iterator() {
        return new RegionIterator(this.flatNode, this.getStartOffset(), this.getEndOffset());
    }
}

