/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.runner.TestTitleRegion;
import org.eclipse.xtext.util.XtextVersion;
import org.junit.runner.Description;

public class DescriptionFactory {
    public static Description createFileDescription(Class<?> clazz, IXpectURIProvider uriProvider, URI uri) {
        URI deresolved = uriProvider.deresolveToProject(uri);
        Description result = DescriptionFactory.createFileDescription(deresolved.trimSegments(1).toString(), deresolved.lastSegment());
        return result;
    }

    public static Description createFileDescription(String pathInProject, String fileName) {
        String name = String.valueOf(fileName) + ": " + pathInProject;
        Description result = Description.createSuiteDescription((String)name, (Annotation[])new Annotation[0]);
        return result;
    }

    public static Description createFileDescription(XpectFile file) {
        URI uri = file.eResource().getURI();
        Preconditions.checkArgument((boolean)uri.isPlatform());
        String pathInProject = Joiner.on((char)'/').join(uri.segmentsList().subList(2, uri.segmentCount() - 1));
        return DescriptionFactory.createFileDescription(pathInProject, uri.lastSegment());
    }

    public static Description createFileDescriptionForError(Class<?> clazz, IXpectURIProvider uriProvider, URI uri) {
        URI deresolved = uriProvider.deresolveToProject(uri);
        String name = String.valueOf(deresolved.lastSegment()) + ": " + deresolved.trimSegments(1).toString();
        Description result = Description.createTestDescription(clazz, (String)name);
        return result;
    }

    public static Description createTestDescription(Class<?> javaClass, IXpectURIProvider uriProvider, XpectInvocation invocation) {
        URI uri = uriProvider.deresolveToProject(EcoreUtil.getURI((EObject)invocation));
        String title = DescriptionFactory.getTitle(invocation);
        List<String> ret = DescriptionFactory.extractXpectMethodNameAndResourceURI(uri.toString());
        String fragmentToXpectMethod = ret.get(0);
        String pathToResource = ret.get(1);
        String text = fragmentToXpectMethod;
        if (!Strings.isNullOrEmpty((String)title)) {
            text = String.valueOf(text) + ": " + title;
        }
        return Description.createTestDescription(javaClass, (String)(String.valueOf(text) + " \u3014" + pathToResource + "\u3015"));
    }

    public static Description createTestDescription(XpectInvocation invocation) {
        String fragmentToXpectMethod;
        URI uri = EcoreUtil.getURI((EObject)invocation);
        Preconditions.checkArgument((boolean)uri.isPlatform());
        String className = invocation.getFile().getJavaModel().getTestOrSuite().getJvmClass().getQualifiedName();
        String pathToResource = Joiner.on((char)'/').join(uri.segmentsList().subList(2, uri.segmentCount()));
        String text = fragmentToXpectMethod = uri.fragment();
        String title = DescriptionFactory.getTitle(invocation);
        if (!Strings.isNullOrEmpty((String)title)) {
            text = String.valueOf(text) + ": " + title;
        }
        return Description.createTestDescription((String)className, (String)(String.valueOf(text) + " \u3014" + pathToResource + "\u3015"), (Annotation[])new Annotation[0]);
    }

    public static List<String> extractXpectMethodNameAndResourceURI(String text) {
        int sharpPos = text.indexOf(35);
        ArrayList<String> result = new ArrayList<String>();
        result.add(text.substring(sharpPos + 1));
        result.add(text.substring(0, sharpPos));
        return result;
    }

    public static String getTitle(XpectInvocation inv) {
        String title;
        String postfix = System.getProperty("xpectTestTitlePostfix");
        String env = System.getProperty("xpectTestTitleShowEnvironment");
        TestTitleRegion titleRegion = inv.getRelatedRegion(TestTitleRegion.class);
        StringBuilder result = new StringBuilder();
        if (titleRegion != null && !Strings.isNullOrEmpty((String)(title = titleRegion.getTitle()))) {
            result.append(title);
        }
        if (!Strings.isNullOrEmpty((String)postfix)) {
            result.append(postfix);
        }
        if (!Strings.isNullOrEmpty((String)env)) {
            result.append(EcorePlugin.IS_ECLIPSE_RUNNING ? ".plugin" : ".standalone");
            result.append(".xtext_" + XtextVersion.getCurrent().getVersion());
        }
        return result.toString();
    }
}

